# Transcripts Module Overview

This module is tasked with processing student transcript requests. These requests have numerous workflows which are characterized by the student's request submission well as payment methods.

1. Email and Bank Payment
2. Registry Online Services, Bank Payment 
3. Student Portal and Bank Payment
4. Registry Online Services, In-person Payment
5. Student Portal, In-person payment
6. Hard copy, In-person payment

The main responsibility of this module is delegation, tracking and processing of transcript requests. Other subsystems and external systems are responsible for transcript request submission (Email, Student Portal, SVGCC Services) as well as payment (Bursary Module).
However, in the absence of the submission feature in Student Portal and and SVGCC Services the module will initially be responsible for request submission.

**Feature Categories**
1. Transcript Request submission
2. Transcript tracking
3. Email payment update
4. Transcript processing
5. Transcript publishing

## 1. Transcript Request submission

### 1.1. Manual form entry

**User Story**
As a user, I can enter transcript request form, so that I can;

**Satisfaction Criteria**
1. Track progress of transcript request.
2. Make request visible to Bursary to receive payment.
3. Make request available to record bank payment

**System-wide Impacts**
Fee is visible to Bursary to process receive payment.

**User Interface Implications**

- Call-to-action button for creating new request
- Form closely matching format of physical request form

**BDD Descriptions**

1. Scenario: Digitize physical transcript request form
Given the transcript request form is submitted via email or in person
When user enters form details
Then the system persists the record to the database
___

## 2. Transcript tracking

### 2.1. View listing of all transcripts requests

**User Story**

As a user, I can view listing of all transcript requests, so that I can;

**Satisfaction Criteria**
Monitor progress of requests.

**System-wide Impacts**

N/A

**User Interface Implications**

1. Dropdown box to select status criteria for transcripts you wish to search for.
2. Paginated list of records based on search criteria

**BDD Descriptions**

1. Scenario: View all transcripts
Given transcripts requests exists
When user request unconstrained list of transcripts
Then the system generates a list of all transcript requests

### 2.2. View listing of outstanding transcripts 

**User Story**

As a user, I can view listing of all outstanding transcript requests, so that I can;

**Satisfaction Criteria**
Monitor progress of requests.

**System-wide Impacts**

N/A

**User Interface Implications**

1. Dropdown box to select status criteria for transcripts you wish to search for.
2. Paginated list of records based on search criteria

**BDD Descriptions**

1. Scenario: View outstanding transcripts
Given transcripts requests exists
When user requests transcript request that are currently outstanding
Then the system generates a list of all transcript requests meeting criteria


### 2.3. View listing of completed transcripts 

**User Story**

As a user, I can view listing of all completed requests, so that I can;

**Satisfaction Criteria**
Monitor progress of requests.

**System-wide Impacts**

N/A

**User Interface Implications**

1. Dropdown box to select status criteria for transcripts you wish to search for.
2. Paginated list of records based on search criteria

**BDD Descriptions**

1. Scenario: View completed transcripts
Given transcripts requests exists
When user requests transcript request that are completed
Then the system generates a list of all transcript requests meeting criteria

## 3. Email payment update

### 3.1. Bank payment submission

**User Story**

As a user, I can add payment receipt  to request, so that I can;

**Satisfaction Criteria**

Indicate amount of fee that was paid via bank deposit.

**System-wide Impacts**

Payment is reflected in Bursary Graduation Services.

**User Interface Implications**

1. Entry form to facilitate creation of receipt.

**BDD Descriptions**

1. Scenario: Record email submission
Given the student submitted the request via email
When the user, records bank receipt information
And uploads the receipt document
Then the system persists the information as a Bursary bank payment
And saves document in application storage

__

## 4. Transcript processing

### 4.1. Generate transcript preview

**User Story**

As as user, I can generate draft transcript, so that I can;

**Satisfaction Criteria**

Generate transcript record.

**System-wide Impacts**

N/A

**User Interface Implications**

1. Call-to-action button on StudentId available actions field in Transcript Request listing.
2. Form containing record for each course sat during registration.

**BDD Descriptions**

1. Scenario: Generate transcript
Given the student has valid registration
When user request transcript generation
Then the system generates transcript preview record

### 4.2. Edit transcript preview

**User Story**

As a user, I can modify course result in place, so that I can;

**Satisfaction Criteria**

1. Ensure transcript does not include erroneous grade result records.
2. Email concerned parties to inform them of discrepancy in student records.
3. GPA value updates accordingly

**System-wide Impacts**

N/A

**User Interface Implications**

- Call-to-action button that transforms course result record from plain text to an editable field

**BDD Descriptions**

1. Scenario: Modify transcript course record
Given the course result generated by system is based on data that is confirmed to be erroneous
When the user submits modification
Then the system updates only the transcript preview record
And it does not update associated student grade source records
And submits email to e-college for reconciliation of grades

### 4.3. Add course to transcript preview

**User Story**

As a user, I can manually add course result to transcript record; so that I can

**Satisfaction Criteria**

1. Add valid missing course result to transcript preview.
2. Email concerned parties to inform them of discrepancy in student records.
3. GPA value updates accordingly

**System-wide Impacts**

N/A

**User Interface Implications**

- Widget to generate empty fields to input new course result.
- GPA value updates accordingly

**BDD Descriptions**

1. Scenario: Add course record to transcript
Given the course result generated by system is based on data that is confirmed to be erroneous
When the user submits modification
Then the system updates only the transcript preview record
And it does not update associated student grade source records
And submits email to e-college for reconciliation of grades

### 4.4. Remove course to transcript preview

**User Story**

As a user, I can remove course result from transcript preview, so that I can;

**Satisfaction Criteria**

1. Ensure transcript does not include erroneous grade result records.
2. Email concerned parties to inform them of discrepancy in student records.
3. GPA value updates accordingly

**System-wide Impacts**

N/A

**User Interface Implications**

- Button to remove course result from transcript record.

**BDD Descriptions**

1. Scenario: Remove course record to transcript
Given the course result generated by system is based on data that is confirmed to be erroneous
When the user submits modification
Then the system updates only the transcript preview record
And it does not update associated student grade source records
And submits email to e-college for reconciliation of grades

### 4.5. Preview transcript document

**User Story**

As a user, I can generate preview of transcript document, so that I can;

**Satisfaction Criteria**

View formatted transcript document.

**System-wide Impacts**

N/A

**User Interface Implications**

- Document preview is displayed in new browser window.

**BDD Descriptions**

1. Scenario: View transcript preview as document
Given transcript preview records are generated
When the user requests a preview of the transcript document
Then the system generates a temporary pdf document

### 4.7. Approve transcript preview

**User Story**

As a user, I can approve transcript, so that I can;

**Satisfaction Criteria**

1. Persist records to database.
2. Generate document to system directory and email document to user.

**System-wide Impacts**

1. File is created in directory.

**User Interface Implications**

- Call-to-action button for transcript approval on page.

**BDD Descriptions**

1. Scenario: Approve transcript
Given the transcript preview record was generated
When the user approves the transcript
Then the system flags all associated records as approve
And generates the pdf transcript document
And persists document to directory 
__

## 5. Transcript publishing

### 5.1. Download transcript

**User Story**

As a user, I can download transcript document; so that I can

**Satisfaction Criteria**

Have access to soft copy of transcript file.

**System-wide Impacts**

N/A

**User Interface Implications**

- Call-to-action button to download document.

**BDD Descriptions**

1. Scenario: Download transcript document
Given the transcript records were approved
And the transcript document generated
When user requests download
Then the system send file to local storage

2. Scenario: 
Given
When
Then

### 5.1. Email transcript

**User Story**

As a user, I cam email approved transcript, so that I can;

**Satisfaction Criteria**

1. Publish email to relevant parties with transcript file attached.
2. Number if times record was printed is incremented.

**System-wide Impacts**

N/A

**User Interface Implications**

- Call-to-action button for generate email form
- Call-to-action button to publish
- Usr feedback on success of operation

**BDD Descriptions**

1. Scenario: Email transcript
Given transcript was approve
When the user requests transcript publishing
Then system generate email and sends it as all identified email addresses
__

