<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

use frontend\models\Application;
use frontend\models\Applicant;
use frontend\models\Division;
use frontend\models\CapeGroup;
use frontend\models\CapeSubjectGroup;
use frontend\models\CapeSubject;
use frontend\models\ApplicationCapesubject;
use frontend\models\AcademicOffering;

$this->title = $model->pageTitle;

$this->params["breadcrumbs"][] =
    [
        "label" => "Find An Student",
        "url" => Url::toRoute(['student/find-a-student'])
    ];

$this->params["breadcrumbs"][] =
    [
        "label" => $model->breadcrumbs->fullName(),
        "url" => Url::toRoute([
            "profile/student-profile",
            "personid" => $model->breadcrumbs->personId(),
            "studentregistrationid" => $model->breadcrumbs->studentRegistrationId()
        ])
    ];

$this->params['breadcrumbs'][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<div class="panel panel-default">
    <div class="panel-body" style=<?= $model->minimumElementHeight() ?>>
        <?= $this->render(
            "application-periods-dropdownlist",
            [
                "applicationPeriodButtonLabel" => $model->applicationPeriodButtonLabel,
                "applicationPeriodsOptions" => $model->applicationPeriods
            ]
        );
        ?>

        <?php if (!empty($model->academicOfferings)) : ?>
            <?= $this->render(
                "programmes-dropdownlist",
                [
                    "programmeOptions" => $model->academicOfferings,
                    "programmeButtonLabel" => $model->programmeButtonLabel
                ]
            );
            ?>
        <?php endif; ?>


        <?php if ($model->academicOfferingIdSelected == true) : ?>
            <?php $form = ActiveForm::begin(["id" => "create-billing-scope-form"]); ?>

            <?php if ($model->displayCapeSelectionForm == true) : ?>
                <?= $this->render(
                    "cape-selection-form",
                    [
                        "capeGroups" => $model->capeGroups,
                        "applicationCapesubjects" => $model->applicationCapesubjectForms,
                        "form" => $form
                    ]
                );
                ?>
            <?php endif; ?>

            <?php if ($model->displaySpecialisationForm == true) : ?>
                <?= $this->render(
                    "specialisation-form",
                    [
                        "displayGeneralSpecialisations" => $model->displayGeneralSpecialisations,
                        "displayMajors" => $model->displayMajors,
                        "displayMinors" => $model->displayMinors,
                        "generalSpecialisations" => $model->generalSpecialisations,
                        "majors" => $model->majors,
                        "minors" => $model->minors,
                        "programmeSpecialisationChoiceForm" => $model->programmeSpecialisationChoiceForm,
                        "form" => $form
                    ]
                );
                ?>
            <?php endif; ?>

            <p>
                <?=
                $form->field($model->detailsForm, "details")
                    ->label("Do you wish to add any comments")
                    ->textArea(["rows" => "6"])
                ?>
            </p>

            <?=
            Html::submitButton(
                "Add",
                ["class" => "btn btn-success pull-right"]
            );
            ?>
            <?php ActiveForm::end(); ?>
        <?php endif ?>
    </div>
</div>