<?php

use yii\widgets\Breadcrumbs;
use dosamigos\datepicker\DatePicker;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

use frontend\models\StudentStatus;

$this->title = 'Edit General Information';

$this->params['breadcrumbs'][] =
    [
        'label' => 'Find An Student',
        'url' => Url::toRoute(['/subcomponents/students/student/find-a-student'])
    ];
$this->params['breadcrumbs'][] =
    [
        'label' => 'Student Profile',
        'url' => Url::toRoute([
            'profile/student-profile',
            'personid' => $personid,
            'studentregistrationid' => $studentregistrationid
        ])
    ];
$this->params['breadcrumbs'][] = $this->title;
?>


<div class="box box-primary table-responsive no-padding" style="font-size:1.2em;">
    <div class="box-header with-border">
        <span class="box-title"><?= $this->title ?></span>
    </div>

    <?php $form = ActiveForm::begin(); ?>
    <div class="box-body">
        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="username">Username:</label>
            <span><?= $general->username; ?></span>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="title">Title:</label>
            <?= $form->field($general, 'title')->label('')->dropDownList(Yii::$app->params['titles'], ["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="firstname">First Name :</label>
            <?= $form->field($general, 'firstname')->label('')->textInput(["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="middlename">Middle Name:</label>
            <?= $form->field($general, 'middlename')->label('')->textInput(["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="lastname">Last Name:</label>
            <?= $form->field($general, 'lastname')->label('')->textInput(["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="gender">Gender:</label>
            <?= $form->field($general, 'gender')->label('')->dropDownList(['male' => 'Male', 'female' => 'Female'], ["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="dateofbirth">Date of Birth:</label>
            <?= $form->field($general, 'dateofbirth')->label(false)->widget(DatePicker::className(), ['inline' => false, 'template' => '{addon}{input}', 'clientOptions' => ['autoclose' => true, 'format' => 'yyyy-mm-dd', "class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="maritalstatus">Marital Status:</label>
            <?= $form->field($general, 'maritalstatus')->label('')->radioList(Yii::$app->params['maritalstatus'], ["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="nationality">Nationality:</label>
            <?= $form->field($general, 'nationality')->label('')->dropDownList(Yii::$app->params['nationality'], ["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="placeofbirth">Place of Birth:</label>
            <?= $form->field($general, 'placeofbirth')->label('')->dropDownList(Yii::$app->params['placeofbirth'], ["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="religion">Religion:</label>
            <?= $form->field($general, 'religion')->label('')->dropDownList(Yii::$app->params['religion'], ["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="sponsorname">Spnsorname:</label>
            <?= $form->field($general, 'sponsorname')->label('')->textInput(["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="studentstatusid">Student Status:</label>
            <?= $form->field($general, 'studentstatusid')->label('')->dropDownList(StudentStatus::getStatuses(), ["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>

        <div class="form-group">
            <label class="control-label col-xs-6 col-sm-5 col-md-5 col-lg-3" for="studentstatusid">Level:</label>
            <?= $form->field($general, 'currentlevel')->label('')->dropDownList([1 => "1", 2 => "2"], ["class" => "no-padding col-xs-6 col-sm-7 col-md-7 col-lg-9"]); ?>
        </div>
    </div>

    <div class="box-footer pull-right">
        <?= Html::submitButton(' Submit', ['class' => 'btn btn-success', 'style' => 'margin-right:20px']); ?>
        <?= Html::a(' Cancel', ['profile/student-profile', 'personid' => $personid, 'studentregistrationid' => $studentregistrationid], ['class' => 'btn  btn-danger']); ?>
    </div>
    <?php ActiveForm::end(); ?>
</div>