<?php

namespace app\subcomponents\students\controllers;

use Yii;
use app\subcomponents\students\UseCases\ReEnrolment\ReEnrolmentRequest;
use common\models\Result;
use common\models\StudentRegistration;
use app\subcomponents\students\UseCases\ReEnrolment\ReEnrolmentViewModel;
use app\subcomponents\students\UseCases\ReEnrolment\ReEnrolmentUseCase;
use yii\base\Model;


class ReEnrolmentController extends \yii\web\Controller
{
    public function actionExecute(
        $personId,
        $studentRegistrationId,
        $applicationPeriodId = null,
        $academicOfferingId = null
    ) {
        $model =
            ReEnrolmentViewModel::create(
                $personId,
                $studentRegistrationId,
                $applicationPeriodId,
                $academicOfferingId
            );

        if ($postData = Yii::$app->request->post()) {
            $studentRegistration =
                StudentRegistration::find()
                ->where([
                    "studentregistrationid" => $studentRegistrationId,
                    "isactive" => 1,
                    "isdeleted" => 0
                ])
                ->one();

            $personnelId = Yii::$app->user->identity->personid;

            $model->detailsForm->load($postData);

            if ($model->displayCapeSelectionForm == true) { //load applicationcapesubjectForms
                Model::loadMultiple($model->applicationCapesubjectForms, $postData);
            }

            if ($model->displaySpecialisationForm == true) { // load ProgrammeSpecialisationForm
                $model->programmeSpecialisationChoiceForm->load($postData);
            }

            $request = new ReEnrolmentRequest(
                $personId,
                $studentRegistration,
                $personnelId,
                $academicOfferingId,
                $model->detailsForm,
                $model->displayCapeSelectionForm,
                $model->applicationCapesubjectForms,
                $model->displaySpecialisationForm,
                $model->programmeSpecialisationChoiceForm,
                $model->isGeneralSpecialisationMandatory,
                $model->isMajorMandatory,
                $model->isMinorMandatory
            );

            $useCase = new ReEnrolmentUseCase();
            $feedback = $useCase->handle($request);
            if ($feedback->isFailure()) {
                Yii::$app->getSession()
                    ->setFlash(
                        "warning",
                        $feedback->getError()->getMessage()
                    );
            } else {
                Yii::$app->getSession()
                    ->setFlash(
                        "success",
                        "New enrolment creation successful"
                    );
                return $this->redirect([
                    "profile/student-profile",
                    "personid" => $personId,
                    "studentregistrationid" => $feedback->getValue()->studentregistrationid
                ]);
            }
        }

        return $this->render("re-enrolment", ["model" => $model]);
    }
}
