<?php

namespace  app\subcomponents\students\UseCases\ReEnrolment;

use Yii;
use common\models\AcademicYear;
use common\models\ApplicationCapesubject;
use common\models\Employee;
use common\models\ProgrammeCatalog;
use common\models\Offer;
use common\models\ReEnrolment;
use common\models\StudentRegistration;

class ReEnrolmentService
{
    private function __construct()
    {
    }

    public static function getReEnrollmentListing($personId)
    {
        $container = array();

        $reEnrollments = ReEnrolment::find()
            ->where(["user_id" => $personId, "is_deleted" => 0])
            ->all();

        if (empty($reEnrollments)) {
            return false;
        }

        foreach ($reEnrollments as $reEnrollment) {
            $keys = array();
            $values = array();
            $combined = array();

            array_push($keys, "date");
            array_push($keys, "previousprogramme");
            array_push($keys, "newprogramme");
            array_push($keys, "deferralofficer");
            array_push($keys, "details");

            $date = date_format(date_create($reEnrollment->date), "d/m/Y");

            $registrationFrom = StudentRegistration::find()
                ->where([
                    "studentregistrationid" => $reEnrollment->previous_student_registration_id,
                    "isdeleted" => 0
                ])
                ->one();
            $offerFrom = Offer::find()
                ->where([
                    "offerid" => $registrationFrom->offerid,
                    "isdeleted" => 0
                ])
                ->one();

            $previousCapeSubjectsNames = array();
            $previousCapeSubjects = array();
            $previousApplication = $offerFrom->getApplication()->one();
            $previousProgramme =
                ProgrammeCatalog::findOne([
                    "programmecatalogid" => $previousApplication->getAcademicoffering()->one()->programmecatalogid
                ]);
            $previousCapeSubjects =
                ApplicationCapesubject::findAll([
                    "applicationid" => $previousApplication->applicationid
                ]);
            foreach ($previousCapeSubjects as $cs) {
                $previousCapeSubjectsNames[] =
                    $cs->getCapesubject()->one()->subjectname;
            }
            $previousProgramme =
                empty($previousCapeSubjects)
                ? self::getFullName($previousProgramme)
                : $previousProgramme->name . ": " . implode(" ,", $previousCapeSubjectsNames);
            $previousYear = AcademicYear::find()
                ->innerJoin("academic_offering", "`academic_year`.`academicyearid` = `academic_offering`.`academicyearid`")
                ->where([
                    "academic_year.isdeleted" => 0,
                    "academic_offering.academicofferingid" => $previousApplication->academicofferingid,
                    "academic_offering.isdeleted" => 0
                ])
                ->all();
            $previousProgramme =
                "(" . $previousYear[0]->title . ") " .  $previousProgramme;

            $newRegistration = StudentRegistration::find()
                ->where([
                    "studentregistrationid" => $reEnrollment->new_student_registration_id,
                    "isdeleted" => 0
                ])
                ->one();
            $newOffer = Offer::find()
                ->where([
                    "offerid" => $newRegistration->offerid,
                    "isdeleted" => 0
                ])
                ->one();

            $newCapeSubjectsNames = array();
            $newCapeSubjects = array();
            $newApplication = $newOffer->getApplication()->one();
            $newProgramme =
                ProgrammeCatalog::findOne([
                    "programmecatalogid" => $newApplication->getAcademicoffering()->one()->programmecatalogid
                ]);
            $newCapeSubjects =
                ApplicationCapesubject::findAll([
                    "applicationid" => $newApplication->applicationid
                ]);
            foreach ($newCapeSubjects as $cs) {
                $newCapeSubjectsNames[] =
                    $cs->getCapesubject()->one()->subjectname;
            }
            $newProgramme =
                empty($newCapeSubjects)
                ? self::getFullName($newProgramme)
                : $newProgramme->name . ": " . implode(" ,", $newCapeSubjectsNames);

            $newYear = AcademicYear::find()
                ->innerJoin("academic_offering", "`academic_year`.`academicyearid` = `academic_offering`.`academicyearid`")
                ->where([
                    "academic_year.isdeleted" => 0,
                    "academic_offering.academicofferingid" => $newApplication->academicofferingid,
                    "academic_offering.isdeleted" => 0
                ])
                ->all();
            $newProgramme = "(" . $newYear[0]->title . ") " .  $newProgramme;

            $deferralOfficer =
                self::getEmployeeName($reEnrollment->personnel_id);

            if (
                $reEnrollment->comments == NULL
                || strcmp($reEnrollment->comments, "") == 0
            )
                $details = "N/A";
            else
                $details = $reEnrollment->comments;

            array_push($values, $date);
            array_push($values, $previousProgramme);
            array_push($values, $newProgramme);
            array_push($values, $deferralOfficer);
            array_push($values, $details);

            $combined = array_combine($keys, $values);
            array_push($container, $combined);

            $keys = NULL;
            $values = NULL;
            $combined = NULL;
        }
        return $container;
    }

    private static function getEmployeeName($personId)
    {
        $employee = Employee::find()
            ->where([
                "personid" => $personId,
                "isactive" => 1,
                "isdeleted" => 0
            ])
            ->one();
        return "{$employee->title} {$employee->firstname} {$employee->lastname}";
    }

    private static function getFullName($programmeCatalog)
    {
        $qual = $programmeCatalog->getQualificationtype()->one();
        if ($qual) {
            return "{$qual->abbreviation} {$programmeCatalog->name} {$programmeCatalog->specialisation}";
        }
        return "{$programmeCatalog->name} {$programmeCatalog->specialisation}";
    }
}
