<?php

namespace  app\subcomponents\students\UseCases\ReEnrolment;

use Yii;
use yii\base\Model;
use app\modules\dtefull\models\exceptions\ModelNotFoundException;

class ProgrammeSpecialisationChoiceForm extends Model
{
    public $general_specialisation_id;
    public $major_id;
    public $minor_id;

    public function rules()
    {
        return [
            [
                ["major_id", "minor_id", "general_specialisation_id"],
                "string",
                "min" => 13
            ],
            [
                ["major_id", "minor_id", "general_specialisation_id"],
                "string",
                "max" => 13
            ]
        ];
    }


    public function attributeLabels()
    {
        return [
            "general_specialisation_id" => "Specialisation",
            "major_id" => "Major",
            "minor_id" => "Minor"
        ];
    }

    public static function create()
    {
        $model = new ProgrammeSpecialisationChoiceForm();
        $model->general_specialisation_id = null;
        $model->major_id = null;
        $model->minor_id = null;
        return $model;
    }

    public function validateUniqueness()
    {
        $specialisations = array();
        if ($this->general_specialisation == true) {
            array_push($specialisations, $this->general_specialisation);
        }
        if ($this->major == true) {
            array_push($specialisations, $this->major);
        }
        if ($this->minor == true) {
            array_push($specialisations, $this->minor);
        }
        if ($this->hasDuplicates($specialisations) == false) {
            return true;
        }
        return false;
    }


    /**
     * Returns true if any item occurs more than once in collection
     *
     * @param string[] $specialisations
     * @return boolean
     */
    private function hasDuplicates($specialisations)
    {
        $uniqueItems = array();
        if (empty($specialisations)) {
            return false;
        }
        foreach ($specialisations as $specialisation) {
            if (in_array($specialisation, $uniqueItems) == true) {
                return true;
            } else {
                array_push($uniqueItems, $specialisation);
            }
        }
        return false;
    }
}
