<?php

namespace app\subcomponents\students\UseCases\ReEnrolment;

use common\models\CapeSubjectGroup;
use common\models\CapeSubject;

class CapeGroup
{
    private $name;
    private $capeSubjectOptions;

    public function __construct($name, $capeSubjectOptions)
    {
        $this->name = $name;
        $this->capeSubjectOptions = $capeSubjectOptions;
    }

    public function name()
    {
        return $this->name;
    }

    public function capeSubjectOptions()
    {
        return $this->capeSubjectOptions;
    }


    public static function create($capeGroup, $academicOfferingId)
    {
        $name = $capeGroup->name;
        $capeSubjectOptions =
            self::generateCapeSubjectOptions(
                $capeGroup->capegroupid,
                $academicOfferingId
            );
        return new CapeGroup($name, $capeSubjectOptions);
    }

    private static function generateCapeSubjectOptions(
        $capeGroupId,
        $academicOfferingId
    ) {
        $options = array();

        $capeSubjectGroups =
            CapeSubjectGroup::find()
            ->innerJoin(
                "cape_subject",
                "`cape_subject_group`.`capesubjectid` = `cape_subject`.`capesubjectid`"
            )
            ->where([
                "cape_subject_group.capegroupid" => $capeGroupId,
                "cape_subject_group.isactive" => 1,
                "cape_subject_group.isdeleted" => 0,
                "cape_subject.academicofferingid" => $academicOfferingId,
                "cape_subject.isactive" => 1,
                "cape_subject.isdeleted" => 0
            ])
            ->all();

        if (empty($capeSubjectGroups)) {
            return $options;
        }

        $options["0"] = "None";
        foreach ($capeSubjectGroups as $capeSubjectGroup) {
            $capeSubject =
                CapeSubject::find()
                ->where(["capesubjectid" => $capeSubjectGroup->capesubjectid])
                ->one();
            $key = strval($capeSubject->capesubjectid);
            $value = strval($capeSubject->subjectname);
            $options[$key] = $value;
        }

        return $options;
    }
}
