<?php

use kartik\export\ExportMenu;
use kartik\grid\GridView;

$this->title = $pageTitle;

$this->params["breadcrumbs"][] =
    ["label" => "Report Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Admissions Reports Listing", "url" => ["admissions/index"]];

$this->params["breadcrumbs"][] =
    [
        "label" => "Outstanding Application Fees",
        "url" => ["application-payments/outstanding-request"]
    ];

$this->params["breadcrumbs"][] = $this->title;

?>

<h1><?= $this->title ?></h1>

<?php if (!empty($dataProvider)) : ?>
    <div class="report-export">
        <?=
        ExportMenu::widget(
            [
                "dataProvider" => $dataProvider,
                "columns" => [
                    [
                        "attribute" => "username",
                        "format" => "text",
                        "label" => "Username"
                    ],
                    [
                        "attribute" => "title",
                        "format" => "text",
                        "label" => "Title"
                    ],
                    [
                        "attribute" => "firstName",
                        "format" => "text",
                        "label" => "First Name"
                    ],
                    [
                        "attribute" => "middleNames",
                        "format" => "text",
                        "label" => "Middle Name"
                    ],
                    [
                        "attribute" => "lastName",
                        "format" => "text",
                        "label" => "Last Name"
                    ],
                    [
                        "attribute" => "email",
                        "format" => "text",
                        "label" => "Email"
                    ]
                ],
                'fontAwesome' => true,
                'dropdownOptions' => [
                    'label' => 'Select Export Type',
                    'class' => 'btn btn-default'
                ],
                'asDropdown' => false,
                'showColumnSelector' => false,
                'filename' => $pageTitle,
                'exportConfig' => [
                    ExportMenu::FORMAT_TEXT => false,
                    ExportMenu::FORMAT_HTML => false,
                    ExportMenu::FORMAT_EXCEL => false,
                    ExportMenu::FORMAT_EXCEL_X => false,
                    // ExportMenu::FORMAT_CSV => false
                ],
            ]
        );
        ?>
    </div><br />
<?php endif; ?>

<?=
GridView::widget(
    [
        "dataProvider" => $dataProvider,
        "columns" => [
            [
                "attribute" => "username",
                "format" => "text",
                "label" => "Username"
            ],
            [
                "attribute" => "title",
                "format" => "text",
                "label" => "Title"
            ],
            [
                "attribute" => "firstName",
                "format" => "text",
                "label" => "First Name"
            ],
            [
                "attribute" => "middleNames",
                "format" => "text",
                "label" => "Middle Name"
            ],
            [
                "attribute" => "lastName",
                "format" => "text",
                "label" => "Last Name"
            ],
            [
                "attribute" => "email",
                "format" => "text",
                "label" => "Email"
            ]
        ]
    ]
);
?>