<?php

namespace app\subcomponents\reports\controllers;

use common\models\AcademicYear;
use common\models\Applicant;
use common\models\ApplicantIntent;
use common\models\BillingModel;
use common\models\UserModel;
use yii\data\ArrayDataProvider;
use yii\helpers\Url;

class ApplicationPaymentsController extends \yii\web\Controller
{
    private static function getAcademicYearLabel($academicYear)
    {
        $applicantIntent =
            ApplicantIntent::find()
            ->where([
                "applicantintentid" => $academicYear->applicantintentid,
                "isactive" => 1,
                "isdeleted" => 0
            ])
            ->one();
        $intentType =
            ($applicantIntent->intenttypeid == 1) ? "(Full-time) " : "(Part-time) ";

        return "{$applicantIntent->name} {$intentType} {$academicYear->title}";
    }

    private static function getAcademicYearHref($academicYear)
    {
        return Url::to(
            [
                "outstanding-report",
                "selectedAcademicYearId" => $academicYear->academicyearid
            ]
        );
    }

    private function generateAcademicYearDropdownList()
    {
        $options = array();

        $activeAcademicYears =
            AcademicYear::find()
            ->where(["isactive" => 1, "isdeleted" => 0])
            ->all();

        if (!empty($activeAcademicYears)) {
            foreach ($activeAcademicYears as $academicYear) {
                $anchorLabel = self::getAcademicYearLabel($academicYear);
                $href = self::getAcademicYearHref($academicYear);
                $options[$anchorLabel] = $href;
            }
        }
        return $options;
    }

    private static function getAcademicYearDropdownListLabel($selectAcademicYearId)
    {
        $label = null;
        if ($selectAcademicYearId == null) {
            $label = "Select academic year ... ";
        } else {
            $academicYear =
                AcademicYear::find()
                ->where(["academicyearid" => $selectAcademicYearId])
                ->one();
            $academicYearLabel = self::getAcademicYearLabel($academicYear);
            $label = "Change from {$academicYearLabel} ...";
        }
        return $label;
    }

    public function actionOutstandingRequest($selectedAcademicYearId = null)
    {
        $pageTitle = "Outstanding Application Fees";
        $academicYearOptions = self::generateAcademicYearDropdownList();
        $academicYearDropdownListLabel =
            self::getAcademicYearDropdownListLabel($selectedAcademicYearId);

        return $this->render(
            "outstanding-request",
            [
                "pageTitle" => $pageTitle,
                "academicYearOptions" => $academicYearOptions,
                "academicYearDropdownListLabel" => $academicYearDropdownListLabel
            ]
        );
    }

    private static function getApplicantsByAcademicYearId($academicYearId)
    {
        $cond = array();
        $cond["applicant.isactive"] = 1;
        $cond["applicant.isdeleted"] = 0;
        $cond["application.applicationstatusid"] = [2, 3, 4, 5, 6, 7, 8, 9, 10, 11];
        $cond["application.isactive"] = 1;
        $cond["application.isdeleted"] = 0;
        $cond["academic_offering.isactive"] = 1;
        $cond["academic_offering.isdeleted"] = 0;
        $cond["academic_offering.academicyearid"] = $academicYearId;

        return Applicant::find()
            ->innerJoin(
                "application",
                "`applicant`.`personid` = `application`.`personid`"
            )
            ->innerJoin(
                "academic_offering",
                "`application`.`academicofferingid` = `academic_offering`.`academicofferingid`"
            )
            ->where($cond)
            ->groupBy('applicant.personid')
            ->orderBy('applicant.lastname ASC')
            ->all();
    }

    public function actionOutstandingReport($selectedAcademicYearId)
    {
        $dataProvider = null;
        $data = array();

        $applicants = self::getApplicantsByAcademicYearId($selectedAcademicYearId);
        if (!empty($applicants)) {
            foreach ($applicants as $applicant) {
                $applicationSubmissionBilling =
                    BillingModel::getApplicantApplicationSubmissionBilling(
                        $applicant
                    );
                if ($applicationSubmissionBilling == true) {
                    continue;
                }
                $row = array();
                $user = UserModel::findUserByID($applicant->personid);
                $row["username"] = $user->username;
                $row["title"] = $applicant->title;
                $row["firstName"] = $applicant->firstname;
                $row["middleNames"] = $applicant->middlename;
                $row["lastName"] = $applicant->lastname;
                $row["email"] = $user->email;
                $data[] = $row;
            }
        }

        $dataProvider =
            new ArrayDataProvider([
                "allModels" => $data,
                "pagination" => ["pageSize" => 200],
                "sort" => ["attributes" => ["username", "lastName", "email"]],
            ]);

        $pageTitle = "Applicants with Outstanding Application Payments Report";
        $academicYearOptions = self::generateAcademicYearDropdownList();
        $academicYearDropdownListLabel =
            self::getAcademicYearDropdownListLabel($selectedAcademicYearId);

        return $this->render(
            "outstanding-report",
            [
                "pageTitle" => $pageTitle,
                "academicYearOptions" => $academicYearOptions,
                "academicYearDropdownListLabel" => $academicYearDropdownListLabel,
                "dataProvider" => $dataProvider,
            ]
        );
    }
}
