<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Programme Catalog';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="programme-catalog-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?php if (Yii::$app->user->can('updateProgramme')): ?>
            <?= Html::a('Add Programme', ['create'], ['class' => 'btn btn-success']) ?>
        <?php endif; ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'name',
            'examinationbodyid',
            'qualificationtypeid',
            'departmentid',
            'creationdate',
             'specialisation',
             'duration',
            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>

</div>
