<?php

use kartik\grid\GridView;

$this->title = $viewModel->pageTitle;

$this->params["breadcrumbs"][] =
    [
        "label" => "Package Change Requests",
        "url" => ["package-change-requests/index"]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<?=
GridView::widget(
    [
        "dataProvider" => $viewModel->dataProvider,
        "columns" => [
            [
                'format' => 'text',
                'label' => 'Request Date',
                'attribute' => 'dateCreated'
            ],
            [
                'format' => 'text',
                'label' => 'Username',
                'attribute' => 'username'
            ],
            [
                'format' => 'text',
                'label' => 'First Name',
                'attribute' => 'firstName'
            ],
            [
                'format' => 'text',
                'label' => 'Last Name',
                'attribute' => 'lastName'
            ],
            [
                'format' => 'raw',
                'label' => 'Current Package',
                'attribute' => 'currentPackage'
            ],
            [
                'format' => 'raw',
                'label' => 'Requested Package',
                'attribute' => 'requestedPackage'
            ],
            [
                'format' => 'text',
                'label' => 'Type',
                'attribute' => 'type'
            ],
            [
                'format' => 'text',
                'label' => 'Status',
                'attribute' => 'status'
            ],
            [
                'format' => 'text',
                'label' => 'Date Reviewed',
                'attribute' => 'dateReviewed'
            ],
            [
                'format' => 'text',
                'label' => 'Date Paid',
                'attribute' => 'datePaid'
            ],
            [
                "format" => "raw",
                "label" => "Actions",
                "value" => function ($row) {
                    return $row["reviewOptions"];
                }
            ],
        ]
    ]
);
?>