<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = $viewModel->pageTitle;
?>

<h1><?= $this->title ?></h1>

<div class="row">
    <div class="col-sm-6 col-md-6">
        <div class="thumbnail" style="min-height:100px">
            <div class="caption text-center">
                <?=
                Html::a(
                    '<h3>Eligibility Assessment</h3>',
                    Url::toRoute(['eligibility-assessment/index'])
                );
                ?>
                <p>
                    Process student account to determine graduation eligibility.
                </p>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6">
        <div class="thumbnail" style="min-height:100px">
            <div class="caption text-center">
                <?=
                Html::a(
                    '<h3>Graduate Students</h3>',
                    Url::toRoute(['graduate-students/index'])
                );
                ?>
                <p>
                    Graduate eligible student accounts.
                </p>
            </div>
        </div>
    </div>
</div>

<div>
    <div class="col-sm-6 col-md-6">
        <div class="thumbnail" style="min-height:100px">
            <div class="caption text-center">
                <?=
                Html::a(
                    '<h3>Graduation Queries</h3>',
                    Url::toRoute(['graduation-queries/index'])
                );
                ?>
                <p>
                    Manage graduation ceremony participation expressions of interests.
                </p>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-md-6">
        <div class="thumbnail" style="min-height:100px">
            <div class="caption text-center">
                <?=
                Html::a(
                    '<h3>Package Change Requests</h3>',
                    Url::toRoute(['package-change-requests/index'])
                );
                ?>
                <p>
                    Process student request to upgrade and downgrade graduation packages.
                </p>
            </div>
        </div>
    </div>
</div>