# Graduation Developer Documentation Module Overview

The Graduation Module manages the graduation eligibility assessment and account updates of student accounts for graduation team members (divIsional staff and registry).

**Feature Categories**
1. Expressions of Interest

2. Eligibility Assessment

3. Status Updates

4. [Graduation Package Management](#4)
- [4.1. View Graduation Package Modification Requests](#GRAD4.1)
- [4.2. View Graduation Package Modification Request](#GRAD4.2)
- [4.3. Approve Graduation Package Modification Request](#GRAD4.3)
- [4.4. Deny Graduation Package Modification Request](#GRAD4.4)

## 1. Expressions of Interest

The registry unit is tasked with procuring the graduation apparel for students. This procurement must happen well in advance to the time in which a student receives confirmation of their eligibility to graduate. Registry therefore sends out emails to students based on their cohort groups to inform them of the graduation packages available and asking then to indicate if they will be participating as well as the package, if any; they will be selecting.

These expressions of interest are handled using email responses and manage on a worksheet. This workflow needs to be integrated into the application services provided to both students and registry to provide a more seamless user experience.

### 1.1. View expressions of interests

**User Story**

As a user, I can view listings of expression of interest by graduation year, so that I can;

**Satisfaction Criteria**

1. See list of student under consideration for graduation.
    N.B: Consideration for graduation mean that student is ungraduated and is attempting courses which if attained would make them eligible. This scope can be extended to explicitly include Resits when the Resit process if integrated into SAT.
2. View whether or not a student intends to take part in graduation.
3. View whether student has selected a graduation package.

**External System Impacts**

N/A

**System-wide Impacts**
 
1. A negative or non-existent expression of interest request may prevent Bursary from accepting payment for graduation package.

**User Interface Implications**

1. Listing must contain following field;
    - Username
    - Programme
    - Entry Cohort
    - Date request sent
    - Status
    - Date request viewed
    - Date of response
    - Participation (Yes/No)
    - Selected package
2. Username field must be a link to view individual expression of interest.
    
**BDD Descriptions**

1. Scenario: User selects unprocessed year of graduation 
Given the expressions of interest for a particular year are yet to be processes
When user selects the year of graduation
Then the system generates a list containing no records.

2. Scenario: User selects processed year of graduation 
Given the expressions of interest for a particular year that was previously processed
When user selects the year of graduation
Then the system generates a list containing all existing expressions of interest

### 1.2. View expression of interest

**User Story**

As a user, I can view a students expression of interest record; so that I can;

**Satisfaction Criteria**

1. Access student participation
2. View their programme completion report

**External System Impacts**

N/A

**System-wide Impacts**

N/A

**User Interface Implications**

1. Show non-editable expression of interest form
2. Display programme completion report

**BDD Descriptions**

1. Scenario: User selects unseen expression of interest record 
Given the expressions of interest has not been viewed by student
When user selects the record
Then the system indicates that student is yet to view expression of interest.

2. Scenario: User selects unanswered expression of interest record 
Given the expressions of interest was viewed but not answered
When user selects the record
Then the system indicates that the record was viewed but not answered

3. Scenario: User selects unanswered expression of interest record 
Given the expressions of interest was viewed but not answered
When user selects the record
Then the system indicates that the record was viewed but not answered

### 1.3. Generate batch expression of interest queries

**User Story**

As a user, I can generate expressions of interests as a batch operation, so that I can;

**Satisfaction Criteria**

1. Send request to all applicable students for a division in one operation.

**External System Impacts**

Expression of Interest is available in Student Portal.

**System-wide Impacts**

N/A

**User Interface Implications**

1. Cohort selection
2. When cohort is selected then a list of students of displayed with call-to-acton button for sending.
    - A students that have already been send Expression of Interests records are disabled.
3. Operation must provide feedback of success or failure.

**BDD Descriptions**
1. Scenario: User generates records for graduating year
Given the user selects the current year of graduation
When user executes generation operation
Then the system generates records for all students in scope
And directs user to report of correspondences sent.

### 1.4. Add single expression of interest to list

**User Story**

As a user, I can send individual expression of interest, so that I can;

**Satisfaction Criteria**

1. Inform student that may fall outside of automatic consideration criteria.

**External System Impacts**

Expression of Interest is available in Student Portal.

**System-wide Impacts**

N/A

**User Interface Implications**

1. Student search widget.
2. Result listing show all students but only allows selection if student has "Current" registration.
3. Listing has call-to-action for eligible records.

**BDD Descriptions**

1. Scenario: User searches for invalid StudentNumber
Given studentID does not exist
When user executes search based on that criteria
Then the system indicates student account can not  be found

2. Scenario: User searches for invalid Student name
Given student name does not exist
When user executes search based on that criteria
Then the system indicates student account can not  be found

3. Scenario: User searches for valid Student
Given student name or student id does exist
When user executes search based on that criteria
Then the system generates listing of applicable students with Publish buttons.

### 1.5. Update expressions of interest query

**User Story**

As a user, I can manually update students expression of interest; so that I can;

**Satisfaction Criteria**

1. Modify a student participation status
2. Modify the level of participation of a student in upcoming graduation.

**External System Impacts**

Result is displayed in Student Portal.

**System-wide Impacts**

The Bursary Module has package preselected.

**User Interface Implications**

1. Show non-editable expression of interest form

**BDD Descriptions**
1. Scenario: User updates expression of interest
Given student has expression of interest 
When user selects record
Then the system generates the editable form
And updates record according to user modification

#### 1.6. Export report

**User Story**

As a user, I can export expression of interest listing; so that I can;

**Satisfaction Criteria**

1. Provide csv formatted copy of report. 

**System-wide Impacts**

N/A

**User Interface Implications**

1. Add call-to-action button to trigger report generation.

**BDD Descriptions**

1. Scenario: User generates expression of interest report
Given user is viewing expression of interest listing for graduation year
When selects report generation 
Then the system generates csv file containing all records in listing
____

## 2. Eligibility Assessment

### 2.1. Generate Cohort Eligibility Report

**User Story**

As a user, I can generate programme completion statistics, so that I can;

**Satisfaction Criteria**

1. Compare a students level of completion based on the current cohort completion requirements.

**External System Impacts**

N/A

**System-wide Impacts**

N/A 

**User Interface Implications**

1. List of students in cohort are listed showing the following fields;
    - Username
    - Programme
    - Entry Cohort
    - Current Cohort
    - Courses Required
    - Courses Completed
    - Completion Status (editable)
2. Username is a link that leads to Programme Completion Report.

**BDD Descriptions**

1. Scenario: User generates preliminary cohort graduation listing
Given user selects graduating year and programme
When user executes operation
Then the system generates a listing of students meeting current graduation criteria
And updates their student statuses to "Eligible To Graduate"

### 2.2. View graduand transcript

**User Story**

As a user, I can view a student's programme completion report, so that I can;

**Satisfaction Criteria**

1. View courses completed
2. View courses outstanding
3. View system generated graduation status

**External System Impacts**

N/A

**System-wide Impacts**

N/A

**User Interface Implications**

1. List of courses needed to graduate with current cohort is listing.
2. Courses taken by students as matched by course requirements.
3. Records where the student don't have a grade for the course are shown highlighted.
4. Call-to-action button to update status to "Eligible To Graduate" / "Current"

**BDD Descriptions**

1. Scenario: User views cohort graduation eligibility report
Given user cohort has been processed at least once
When user selects any record
Then the system generates student graduation eligibility report.

### 2.3. Update graduand candidate status

**User Story**

As a user, I can manually update a students graduation eligibility status, so that I can;

**Satisfaction Criteria**

1. Assign status of "Eligible To Graduate"
2. Assign status as "Current"

**External System Impacts**

Status is updated in Student Portal.

**System-wide Impacts**

Status of student registration in student profile updated.

**User Interface Implications**

1. Confirmation message when operation is complete.

**BDD Descriptions**

1. Scenario: User updates student graduation eligibility status
Given student registration exists in graduation eligibility report
When user selects status modification controls
And user modifies record
Then the system updates student graduation eligibility.

#### 2.2. Export Report

**User Story**

As a user, I can export eligibility listing, so that I can;

**Satisfaction Criteria**

1. Provide csv formatted copy of report. 

**External System Impacts**

N/A

**System-wide Impacts**

N/A

**User Interface Implications**

N/A

**BDD Descriptions**

1. Scenario: User generates cohort graduation eligibility listing
Given eligibility operation was performed for cohort
When user executes operation
Then the generates csv file containing listing information.
____

## 3. Status Updates

### 3.1. Batch update statuses

**User Story**

As a user, I can Graduate entire cohorts, so that I can;

**Satisfaction Criteria**

1. Update all student with statuses of "Eligible to Graduate" to "Graduated" in one operation.

**External System Impacts**

Updated status is displayed in Student Portal account.

**System-wide Impacts**

Updated status is displayed in Student Profile.

**User Interface Implications**

1. Select cohort
2. List applicable students with status of "Eligible to Graduate"
3. Call-to-action button for operation.
4. Confirmation message when operation completed successfully.

**BDD Descriptions**

1. Scenario: User graduates students
Given user selects graduating cohort
When user request update operation
Then the system updates all students with statuses of "Eligible To Graduate" to "Graduated"
____

