<?php

namespace app\subcomponents\graduation\controllers;

use Yii;
use app\subcomponents\graduation\models\PackageChangeRequestsHomeViewModel;
use app\subcomponents\graduation\models\PackageChangeRequestsListingViewModel;
use common\models\GraduationPackageChangeRequest;
use yii\web\Controller;


class PackageChangeRequestsController extends Controller
{
    public function actionIndex()
    {
        $viewModel =
            PackageChangeRequestsHomeViewModel::create("Package Change Requests");

        return $this->render("index", ["viewModel" => $viewModel]);
    }

    public function actionViewRequests($status)
    {
        if ($status == "view-all") {
            return $this->redirect(["view-all"]);
        }
    }

    public function actionViewAll()
    {
        $viewModel = PackageChangeRequestsListingViewModel::create("view-all");
        return $this->render("listing", ["viewModel" => $viewModel]);
    }

    public function actionApprove($id)
    {
        $model =
            GraduationPackageChangeRequest::find()
            ->where(["id" => $id, "is_active" => 1, "is_deleted" => 0])
            ->one();

        $model->graduation_package_change_request_status_id = 2;
        $model->date_reviewed = date("Y-m-d H:i:s");
        $svgccPersonnel = Yii::$app->user->identity;
        $model->reviewed_by = $svgccPersonnel->personid;

        if ($model->save() == true) {
            Yii::$app->session->setFlash("success", "Request approved.");
        } else {
            Yii::$app->session->setFlash("error", "Error occurred approving request.");
        }

        return $this->redirect(\Yii::$app->request->getReferrer());
    }


    public function actionReject($id)
    {
        $model =
            GraduationPackageChangeRequest::find()
            ->where(["id" => $id, "is_active" => 1, "is_deleted" => 0])
            ->one();

        $model->graduation_package_change_request_status_id = 3;
        $model->date_reviewed = date("Y-m-d H:i:s");
        $svgccPersonnel = Yii::$app->user->identity;
        $model->reviewed_by = $svgccPersonnel->personid;

        if ($model->save() == true) {
            Yii::$app->session->setFlash("success", "Request rejected");
        } else {
            Yii::$app->session->setFlash("error", "Error occurred rejecting request.");
        }

        return $this->redirect(\Yii::$app->request->getReferrer());
    }
}
