<?php

namespace app\subcomponents\bursary\views\viewmodels\registryandlibraryservices;

use yii\helpers\ArrayHelper;

/**
 * Holds all payment data for library and registry fee payment transactions.
 */
class RegistryAndLibraryFeesViewModel
{
    public $title;
    public $studentRegistrationId;
    public $academicOfferingId;
    public $applicationPeriodId;
    public $customerId;
    public $username;
    public $userFullName;
    public $receiptForm;
    public $billingForms;
    public $paymentMethods;
    public $personnelId;
    public $customerEmail;


    /**
     * Class constructor
     *
     * @param string $title
     * @param integer $studentRegistrationId
     * @param integer $academicOfferingId
     * @param integer $applicationPeriodId
     * @param integer $customerId
     * @param string $username
     * @param string $userFullName
     * @param ReceiptForm $receiptForm
     * @param array $billingForms
     * @param array $paymentMethods
     * @param integer $personnelId
     * @param string $customerEmail
     */
    private function __construct(
        $title,
        $studentRegistrationId,
        $academicOfferingId,
        $applicationPeriodId,
        $customerId,
        $username,
        $userFullName,
        $receiptForm,
        $billingForms,
        $paymentMethods,
        $personnelId,
        $customerEmail

    ) {
        $this->title = $title;
        $this->studentRegistrationId = $studentRegistrationId;
        $this->academicOfferingId = $academicOfferingId;
        $this->applicationPeriodId = $applicationPeriodId;
        $this->customerId = $customerId;
        $this->username = $username;
        $this->userFullName = $userFullName;
        $this->receiptForm = $receiptForm;
        $this->billingForms = $billingForms;
        $this->paymentMethods = $paymentMethods;
        $this->personnelId = $personnelId;
        $this->customerEmail = $customerEmail;
    }


    /**
     * Builds model
     *
     * @param integer $studentRegistrationId
     * @param StudentRegistrationRepository $studentRegistrationRepository
     * @param ApplicationPeriodRepository $applicationPeriodRepository
     * @param UserRepository $userRepository
     * @param StudentRepository $studentRepository
     * @param BillingChargeRepository $billingChargeRepository
     * @param PaymentMethodRepository $paymentMethodRepository
     * @param int $personnelId
     * @return RegistryAndLibraryFeesViewModel
     */
    public static function create(
        $studentRegistrationId,
        $studentRegistrationRepository,
        $applicationPeriodRepository,
        $userRepository,
        $studentRepository,
        $billingChargeRepository,
        $paymentMethodRepository,
        $personnelId
    ) {
        $title = "Registry and Library Student Service Payments";

        $studentRegistration =
            $studentRegistrationRepository->getStudentRegistrationById(
                $studentRegistrationId
            );
        $customer = $userRepository->getUserById($studentRegistration->personid);
        $username = $customer->username;

        $userFullName =
            $studentRepository->getStudentFullNameByPersonId(
                $studentRegistration->personid
            );

        $receiptForm = new ReceiptForm();
        $receiptForm->username = $username;
        $receiptForm->fullName = $userFullName;
        $receiptForm->notes = null;

        $applicationPeriod =
            $applicationPeriodRepository->getApplicationPeriodFromRegistration(
                $studentRegistration
            );

        $billingForms = array();
        $applicableBillingCharges =
            $billingChargeRepository->getRegistryAndLibraryServiceBillingChargesForApplicationPeriod(
                $applicationPeriod
            );
        if (!empty($applicableBillingCharges)) {
            foreach ($applicableBillingCharges as $billingCharge) {
                $billingForm = new BillingForm();
                $billingForm->isActive = 0;
                $billingForm->billingChargeId = $billingCharge->id;
                $billingForm->feeName =
                    $billingChargeRepository->getBillingChargeFeeName($billingCharge);
                $billingForm->cost = $billingCharge->cost;
                $billingForm->quantity = 1;
                $billingForms[] = $billingForm;
            }
        }

        $paymentMethods =
            ArrayHelper::map(
                $paymentMethodRepository->getNonWaiverPaymentMethods(),
                "name",
                "name"
            );

        return new RegistryAndLibraryFeesViewModel(
            $title,
            $studentRegistrationId,
            $studentRegistration->academicofferingid,
            $applicationPeriod->applicationperiodid,
            $studentRegistration->personid,
            $username,
            $userFullName,
            $receiptForm,
            $billingForms,
            $paymentMethods,
            $personnelId,
            $customer->email
        );
    }


    /**
     * Returns summation of billing costs
     *
     * @return float
     */
    public function getBillingFormsTotal()
    {
        $total = 0;
        foreach ($this->billingForms as $billing) {
            $total += ($billing->cost * $billing->quantity);
        }
        return (float)$total;
    }


    /**
     * Generates code from employees name.
     * 
     * This code is included in payment receipts.
     *
     * @param EmployeeRepository $employeeRepository
     * @return string
     */
    public function getPersonnelCode($employeeRepository)
    {
        $employee = $employeeRepository->getEmployeeByPersonId($this->personnelId);
        $last = substr($employee->lastname, 0, 3);
        $first = substr($employee->firstname, 0, 3);
        $code = "{$last}{$first}";
        return strtoupper($code);
    }
}
