<?php

namespace app\subcomponents\bursary\views\viewmodels\registryandlibraryservices;

use yii\base\Model;

class ReceiptForm extends Model
{
    public $username;
    public $fullName;
    public $datePaid;
    public $notes;
    public $chequeNumber;
    public $payUsingCheque;

    /**
     * @inheritdoc
     * 
     * Framework enforced user interface form validation rules
     */
    public function rules()
    {
        return [
            [
                [
                    "username",
                    "fullName",
                    "datePaid",
                    "payUsingCheque"
                ],
                "required"
            ],
            [["username", "fullName", "chequeNumber", "notes"], "string"],
            [["payUsingCheque"], "integer"],
            [["datePaid"], "safe"]
        ];
    }


    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            "username" => "ApplicantID",
            "fullName" => "Full Name",
            "datePaid" => "Date of payment",
            "chequeNumber" => "Cheque Number",
            "notes" => "Notes",
            "payUsingCheque" => "Is any part of this payment made using cheque?"
        ];
    }
}
