<?php

namespace app\subcomponents\bursary\views\viewmodels\registryandlibraryservices;

/**
 * Data payload object for data needed for display on receipt file template
 */
class ReceiptFileModel
{

    public $receiptNumber;
    public $operatorCode;
    public $paymentMethod;
    public $datePaid;
    public $clientUsername;
    public $clientFullName;
    public $total;
    public $billings;

    /**
     * Class constructor
     *
     * @param string $receiptNumber
     * @param string $operatorCode
     * @param string $paymentMethod
     * @param string $datePaid
     * @param string $clientUsername
     * @param string $clientFullName
     * @param string $total
     * @param array $billings
     */
    public function __construct(
        $receiptNumber,
        $operatorCode,
        $paymentMethod,
        $datePaid,
        $clientUsername,
        $clientFullName,
        $total,
        $billings
    ) {
        $this->receiptNumber = $receiptNumber;
        $this->operatorCode = $operatorCode;
        $this->paymentMethod = $paymentMethod;
        $this->datePaid = $datePaid;
        $this->clientUsername = $clientUsername;
        $this->clientFullName = $clientFullName;
        $this->total = $total;
        $this->billings = $billings;
    }
}
