<?php

namespace app\subcomponents\bursary\views\viewmodels\registryandlibraryservices;

/**
 * Holds detailed billing item information of receipt document preview
 */
class BillingPreview
{
    public $selected;
    public $cost;
    public $quantity;
    public $paymentMethod;
    public $billingChargeId;
    public $billingChargeName;
    public $total;


    /**
     * Class constructor
     *
     * @param integer $selected  Indicates if billing item was selected to be included in receipt
     * @param float $cost
     * @param integer $quantity
     * @param string $paymentMethod
     * @param integer $billingChargeId
     * @param string $billingChargeName
     */
    public function __construct(
        $selected,
        $cost,
        $quantity,
        $paymentMethod,
        $billingChargeId,
        $billingChargeName
    ) {
        $this->selected = $selected;
        $this->cost = number_format($cost, 2);
        $this->quantity = $quantity;
        $this->paymentMethod = $paymentMethod;
        $this->billingChargeId = $billingChargeId;
        $this->billingChargeName = $billingChargeName;
        $this->total = number_format(($cost * $quantity), 2);
    }
}
