<?php

namespace app\subcomponents\bursary\views\viewmodels\registryandlibraryservices;

use yii\base\Model;
use frontend\adapters\driven\real\persistence\BillingCharge;

class BillingForm extends Model
{
    public $billingChargeId;
    public $feeName;
    public $cost;
    public $quantity;
    public $isActive;
    public $paymentMethod;


    /**
     * @inheritdoc
     * 
     * Framework enforced user interface form validation rules
     */
    public function rules()
    {
        return [
            [["cost"], "number"],
            [["feeName", "paymentMethod"], "string"],
            [
                [
                    "billingChargeId",
                    "isActive",
                    "quantity"
                ],
                "integer"
            ],
            [
                ["billing_charge_id"],
                "exist",
                "skipOnError" => true,
                "targetClass" => BillingCharge::class,
                "targetAttribute" => ["billingChargeId" => "id"]
            ],
        ];
    }


    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            "feeName" => "Fee",
            "billing_charge_id" => "Billing Charge ID",
            "cost" => "Cost",
            "quantity" => "Quantity",
            "isActive" => "Save",
            "paymentMethod" => "Payment Method",
        ];
    }

    public function validateModel()
    {
        if (
            $this->isActive == true
            && $this->paymentMethod == true
            && $this->quantity > 0
        ) {
            return true;
        }
        return false;
    }
}
