<?php

use dosamigos\datepicker\DatePicker;
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
?>

<div id="outstanding-enrollment-fees-form" class="panel panel-default" style="display:none">
    <div class="panel-heading">
        <h3 class="panel-title">
            <span>Process Outstanding Fees</span>
        </h3>
    </div>
    <div class="panel-body">
        <?php $form = ActiveForm::begin(); ?>

        <?=
        $form->field($batchStudentFeePaymentForm, "username")
            ->textInput(["class" => "form-control", "readonly" => true]);
        ?>

        <?=
        $form->field($batchStudentFeePaymentForm, "fullName")
            ->textInput(["class" => "form-control", "readonly" => true]);
        ?>

        <?=
        $form->field($batchStudentFeePaymentForm, 'datePaid')
            ->widget(
                DatePicker::class,
                [
                    'inline' => false,
                    'template' => '{addon}{input}',
                    'clientOptions' =>
                    ['autoclose' => true, 'format' => 'yyyy-mm-dd']
                ]
            );
        ?>

        <?=
        $form->field($batchStudentFeePaymentForm, "payUsingCheque")
            ->inline()
            ->radioList(
                [0 => "No", 1 => "Yes"],
                ["onClick" => "toggleChequeNumberField()"]
            );
        ?>

        <?php if ($batchStudentFeePaymentForm->chequeNumber == true) : ?>
            <div id="cheque-number-field" style="display:block">
                <?=
                $form->field($batchStudentFeePaymentForm, "chequeNumber")
                    ->textInput(["class" => "form-control"]);
                ?>
            </div>
        <?php else : ?>
            <div id="cheque-number-field" style="display:none">
                <?=
                $form->field($batchStudentFeePaymentForm, "chequeNumber")
                    ->textInput(["class" => "form-control"]);
                ?>
            </div>
        <?php endif; ?>

        <br />
        <table class="table table-striped">
            <tr>
                <th></th>
                <th>Fee</th>
                <th>Balance</th>
                <th>Amt. Received</th>
                <th>Payment Method</th>
            </tr>


            <?php foreach ($batchStudentFeePaymentBillingForms as $key => $value) : ?>
                <tr>
                    <td width="5%">
                        <?=
                        $form->field(
                            $batchStudentFeePaymentBillingForms[$key],
                            "[{$key}]isActive"
                        )
                            ->checkbox(['label' => false]);
                        ?>
                    </td>

                    <td width="35%">
                        <?=
                        $form->field(
                            $batchStudentFeePaymentBillingForms[$key],
                            "[{$key}]fee"
                        )
                            ->label(false)
                            ->textInput(["readonly" => true]);
                        ?>
                    </td>

                    <td width="20%">
                        <?=
                        $form->field(
                            $batchStudentFeePaymentBillingForms[$key],
                            "[{$key}]balance"
                        )
                            ->label(false)
                            ->textInput(["readonly" => true]);
                        ?>
                    </td>

                    <td width="20%">
                        <?=
                        $form->field(
                            $batchStudentFeePaymentBillingForms[$key],
                            "[{$key}]amountPaid"
                        )
                            ->label(false)
                            ->textInput();
                        ?>
                    </td>

                    <td width="20%">
                        <?=
                        $form->field(
                            $batchStudentFeePaymentBillingForms[$key],
                            "[{$key}]paymentMethodId"
                        )
                            ->label(false)
                            ->dropDownList($paymentMethods);
                        ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>

        <?=
        Html::submitButton(
            "Add",
            ["class" => "btn btn-success pull-right"]
        );
        ?>
        <?php ActiveForm::end(); ?>
    </div>
</div>

<script>
    function toggleChequeNumberField() {
        const paymentMethodField =
            document.getElementById("batchstudentfeepaymentform-payusingcheque");

        if (paymentMethodField === null) {
            //do nothing
        } else {
            let chequeNumberField =
                document.getElementById("cheque-number-field");
            let selectedIndex = paymentMethodField.selectedIndex;
            var radio = paymentMethodField.getElementsByTagName("input");
            var label = paymentMethodField.getElementsByTagName("label");
            let selectedValue = null;
            for (var i = 0; i < radio.length; i++) {
                if (radio[i].checked) {
                    selectedValue = label[i].innerHTML;
                }
            }

            if (selectedValue.includes("Yes")) {
                chequeNumberField.style.display = "block";
            } else {
                chequeNumberField.style.display = "none";
                document.getElementById(
                    "batchstudentfeepaymentform-chequenumber"
                ).value = null;
            }
        }
    }
</script>