<?php

use dosamigos\datepicker\DatePicker;
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;

$this->title = "Pay {$fee}";

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" => $userFullname,
        "url" => ["profiles/redirect-to-customer-profile", "username" => $username]
    ];

$this->params["breadcrumbs"][] =
    [
        "label" => "Enrollment Payments",
        "url" => ["successful-applicant-payments/enrollment-payments-report", "username" => $username]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<div class="panel panel-default">
    <div class="panel-body">
        <?php $form = ActiveForm::begin(); ?>
        <?=
        $form->field($model, "username")
            ->textInput(["class" => "form-control", "readonly" => true]);
        ?>

        <?=
        $form->field($model, "fullName")
            ->textInput(["class" => "form-control", "readonly" => true]);
        ?>

        <?=
        $form->field($model, "balance")
            ->label("Amount Due")
            ->textInput(["class" => "form-control", "readonly" => true]);
        ?>

        <?=
        $form->field($model, "amountPaid")
            ->label("Payment")
            ->textInput(["class" => "form-control"]);
        ?>

        <?=
        $form->field($model, 'datePaid')
            ->widget(
                DatePicker::class,
                [
                    'inline' => false,
                    'template' => '{addon}{input}',
                    'clientOptions' =>
                    ['autoclose' => true, 'format' => 'yyyy-mm-dd']
                ]
            );
        ?>

        <?=
        $form->field($model, "paymentMethodId")
            ->inline()
            ->radioList(
                $paymentMethods,
                ["onClick" => "toggleChequeNumberField()"]
            );
        ?>

        <?php if ($model->chequeNumber == true) : ?>
            <div id="cheque-number-field" style="display:block">
                <?=
                $form->field($model, "chequeNumber")
                    ->textInput(["class" => "form-control"]);
                ?>
            </div>
        <?php else : ?>
            <div id="cheque-number-field" style="display:none">
                <?=
                $form->field($model, "chequeNumber")
                    ->textInput(["class" => "form-control"]);
                ?>
            </div>
        <?php endif; ?>

        <?= Html::submitButton("Add", ["class" => "btn btn-success pull-right"]); ?>
        <?php ActiveForm::end(); ?>
    </div>
</div>

<script>
    function toggleChequeNumberField() {
        const paymentMethodField =
            document.getElementById("singlestudentfeepaymentform-paymentmethodid");

        if (paymentMethodField === null) {
            //do nothing
        } else {
            let chequeNumberField =
                document.getElementById("cheque-number-field");
            let selectedIndex = paymentMethodField.selectedIndex;
            var radio = paymentMethodField.getElementsByTagName("input");
            var label = paymentMethodField.getElementsByTagName("label");
            let selectedValue = null;
            for (var i = 0; i < radio.length; i++) {
                if (radio[i].checked) {
                    selectedValue = label[i].innerHTML;
                }
            }

            if (selectedValue.includes("Cheque")) {
                chequeNumberField.style.display = "block";
            } else {
                chequeNumberField.style.display = "none";
                document.getElementById(
                    "singlestudentfeepaymentform-chequenumber"
                ).value = null;
            }
        }
    }
</script>