<?php

use dosamigos\datepicker\DatePicker;
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = "$serviceFeeCatalog->title";

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" => $serviceFeeCatalog->userFullName,
        "url" => [
            "profiles/redirect-to-customer-profile",
            "username" => $serviceFeeCatalog->username
        ]
    ];

$this->params["breadcrumbs"][] =
    [
        "label" => "Payment Options",
        "url" => [
            "student-payments/payment-options",
            "username" => $serviceFeeCatalog->username
        ]
    ];

$this->params["breadcrumbs"][] = $this->title;

?>


<h1><?= $this->title ?></h1>

<div class="panel panel-default">
    <div class="panel-body">

        <?php
        $form =
            ActiveForm::begin(
                [
                    "action" => Url::to(
                        [
                            "preview-payment",
                            "studentRegistrationId" =>
                            $serviceFeeCatalog->studentRegistrationId
                        ]
                    )
                ]
            );
        ?>

        <?=
        $form->field(
            $serviceFeeCatalog->receiptForm,
            "username"
        )
            ->textInput(["class" => "form-control", "readonly" => true]);
        ?>

        <?=
        $form->field(
            $serviceFeeCatalog->receiptForm,
            "fullName"
        )
            ->textInput(["class" => "form-control", "readonly" => true]);
        ?>

        <?=
        $form->field(
            $serviceFeeCatalog->receiptForm,
            'datePaid'
        )
            ->widget(
                DatePicker::class,
                [
                    'inline' => false,
                    'template' => '{addon}{input}',
                    'clientOptions' =>
                    ['autoclose' => true, 'format' => 'yyyy-mm-dd']
                ]
            );
        ?>

        <?=
        $form->field(
            $serviceFeeCatalog->receiptForm,
            "notes"
        )
            ->textarea(["rows" => 5]);
        ?>

        <?=
        $form->field(
            $serviceFeeCatalog->receiptForm,
            "payUsingCheque"
        )
            ->inline()
            ->radioList(
                [0 => "No", 1 => "Yes"],
                ["onClick" => "toggleChequeNumberField()"]
            );
        ?>

        <?php if ($serviceFeeCatalog->receiptForm->chequeNumber == true) : ?>
            <div id="cheque-number-field" style="display:block">
                <?=
                $form->field(
                    $serviceFeeCatalog->receiptForm,
                    "chequeNumber"
                )
                    ->textInput(["class" => "form-control"]);
                ?>
            </div>
        <?php else : ?>
            <div id="cheque-number-field" style="display:none">
                <?=
                $form->field(
                    $serviceFeeCatalog->receiptForm,
                    "chequeNumber"
                )
                    ->textInput(["class" => "form-control"]);
                ?>
            </div>
        <?php endif; ?>
        <br />

        <table class="table table-striped">
            <tr>
                <th></th>
                <th>Fee</th>
                <th>Cost</th>
                <th>Quantity</th>
                <th>Payment Method</th>
            </tr>

            <?php foreach ($serviceFeeCatalog->billingForms as $key => $value) : ?>
                <tr>
                    <td width="5%">
                        <?=
                        $form->field(
                            $serviceFeeCatalog->billingForms[$key],
                            "[{$key}]isActive"
                        )
                            ->checkbox(['label' => false]);
                        ?>
                    </td>

                    <td width="40%">
                        <?=
                        $form->field(
                            $serviceFeeCatalog->billingForms[$key],
                            "[{$key}]feeName"
                        )
                            ->label(false)
                            ->textInput(["readonly" => true]);
                        ?>
                    </td>

                    <td width="15%">
                        <?=
                        $form->field(
                            $serviceFeeCatalog->billingForms[$key],
                            "[{$key}]cost"
                        )
                            ->label(false)
                            ->textInput(["readonly" => true]);
                        ?>
                    </td>

                    <td width="10%">
                        <?=
                        $form->field(
                            $serviceFeeCatalog->billingForms[$key],
                            "[{$key}]quantity"
                        )
                            ->label(false)
                            ->textInput();
                        ?>
                    </td>


                    <td width="30%">
                        <?=
                        $form->field(
                            $serviceFeeCatalog->billingForms[$key],
                            "[{$key}]paymentMethod"
                        )
                            ->label(false)
                            ->dropDownList(
                                $serviceFeeCatalog->paymentMethods
                            );
                        ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>

        <?= Html::submitButton("Preview", ["class" => "btn btn-success pull-right"]) ?>
        <?php ActiveForm::end(); ?>
    </div>
</div>


<script>
    function toggleChequeNumberField() {
        const paymentMethodField =
            document.getElementById("receiptform-payusingcheque");

        if (paymentMethodField === null) {
            //do nothing
        } else {
            let chequeNumberField =
                document.getElementById("cheque-number-field");
            let selectedIndex = paymentMethodField.selectedIndex;
            var radio = paymentMethodField.getElementsByTagName("input");
            var label = paymentMethodField.getElementsByTagName("label");
            let selectedValue = null;
            for (var i = 0; i < radio.length; i++) {
                if (radio[i].checked) {
                    selectedValue = label[i].innerHTML;
                }
            }

            if (selectedValue.includes("Yes")) {
                chequeNumberField.style.display = "block";
            } else {
                chequeNumberField.style.display = "none";
                document.getElementById("receiptform-chequenumber").value = null;
            }
        }
    }
</script>