<?php

use yii\helpers\Url;
use yii\helpers\Html;
use dosamigos\datepicker\DatePicker;
use yii\bootstrap\ActiveForm;

$this->title = "Receipt Preview";

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" => $paymentPreview->receiptPreview->customerFullName,
        "url" => [
            "profiles/redirect-to-customer-profile",
            "username" => $paymentPreview->receiptPreview->customerUsername
        ]
    ];

$this->params["breadcrumbs"][] =
    [
        "label" => "Payment Options",
        "url" => [
            "student-payments/payment-options",
            "username" => $paymentPreview->receiptPreview->customerUsername
        ]
    ];

$this->params["breadcrumbs"][] =
    [
        "label" => "Library and Registry Student Service Payments",
        "url" => [
            "student-service-payments/service-fee-catalog",
            "studentRegistrationId" => $paymentPreview->receiptPreview->studentRegistrationId
        ]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>


<div class="panel panel-default">
    <div>
        <?php if (stripos(Url::home(true), "localhost") == false) : ?>
            <img src="https://sat.svgcc.vc/images/email_header.png" alt="email_header" class="img-rounded" style="max-width:700px; max-height:150px" />
        <?php else : ?>
            <img src="img/email_header.png" alt="email_header" class="img-rounded" style="max-width:700px; max-height:150px" />
        <?php endif; ?>
    </div><br />

    <div class="panel-body">
        <div>
            SVGCC Payment Receipt<br />
            Receipt#: Pending...<br />
            Tel:1-784-457-4503<br /><br />
            St. Vincent and the Grenadines Community College<br />
            PO Box 829<br />
            Villa<br />
            St. Vincent and the Grenadines<br />
        </div><br />

        <div>
            <strong>Operator:</strong> <?= $paymentPreview->receiptPreview->operatorCode ?><br />
            <strong>Payment Method:</strong> <?= $paymentPreview->receiptPreview->paymentMethod ?><br />
            <strong>Date:</strong> <?= $paymentPreview->receiptPreview->formattedPaidDate ?><br />
            <strong>CustomerID:</strong> <?= $paymentPreview->receiptPreview->customerUsername ?><br />
            <strong>Name:</strong> <?= $paymentPreview->receiptPreview->customerFullName ?><br />
        </div><br />

        <table class="table table-hover" style="text-align:left">
            <tr>
                <td><strong>Fee</strong></td>
                <td><strong>Cost</strong></td>
                <td><strong>Quantity</strong></td>
                <td><strong>Paid</strong></th>
            </tr>
            <?php foreach ($paymentPreview->billingsPreview as $billing) : ?>
                <?php if ($billing->selected == true) : ?>
                    <tr>
                        <td><?= $billing->billingChargeName ?></td>
                        <td>$<?= $billing->cost ?></td>
                        <td><?= $billing->quantity ?></td>
                        <td>$<?= $billing->total ?></td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; ?>

            <tr>
                <td><strong>Total</strong></td>
                <td></td>
                <td></td>
                <td>$<?= $paymentPreview->receiptPreview->total ?></td>
            </tr>
        </table>

        <?php if (stripos(Url::home(true), "localhost") == false) : ?>
            <img src="https://sat.svgcc.vc/images/college_stamp.png" alt="college_stamp" class="img-rounded" style="width:189px; height:74px" />
        <?php else : ?>
            <img src="img/college_stamp.png" alt="college_stamp" class="img-rounded" style="width:189px; height:74px" />
        <?php endif; ?>
    </div><br />
</div>

<?php
$form = ActiveForm::begin([
    "action" =>
    Url::to(
        [
            "confirm-payment",
            "studentRegistrationId" =>
            $paymentPreview->receiptPreview->studentRegistrationId
        ]
    )
]);
?>

<div id="hidden-form" style="display:none">
    <?=
    $form->field(
        $serviceFeeCatalog->receiptForm,
        "username"
    )
        ->textInput(["class" => "form-control", "readonly" => true]);
    ?>

    <?=
    $form->field(
        $serviceFeeCatalog->receiptForm,
        "fullName"
    )
        ->textInput(["class" => "form-control", "readonly" => true]);
    ?>

    <?=
    $form->field(
        $serviceFeeCatalog->receiptForm,
        'datePaid'
    )
        ->widget(
            DatePicker::class,
            [
                'inline' => false,
                'template' => '{addon}{input}',
                'clientOptions' =>
                ['autoclose' => true, 'format' => 'yyyy-mm-dd']
            ]
        );
    ?>

    <?=
    $form->field(
        $serviceFeeCatalog->receiptForm,
        "notes"
    )
        ->textarea(["rows" => 5]);
    ?>

    <?=
    $form->field(
        $serviceFeeCatalog->receiptForm,
        "payUsingCheque"
    )
        ->inline()
        ->radioList(
            [0 => "No", 1 => "Yes"],
            ["onClick" => "toggleChequeNumberField()"]
        );
    ?>

    <?php if ($serviceFeeCatalog->receiptForm->chequeNumber == true) : ?>
        <div id="cheque-number-field" style="display:block">
            <?=
            $form->field(
                $serviceFeeCatalog->receiptForm,
                "chequeNumber"
            )
                ->textInput(["class" => "form-control"]);
            ?>
        </div>
    <?php else : ?>
        <div id="cheque-number-field" style="display:none">
            <?=
            $form->field(
                $serviceFeeCatalog->receiptForm,
                "chequeNumber"
            )
                ->textInput(["class" => "form-control"]);
            ?>
        </div>
    <?php endif; ?>
    <br />

    <table class="table table-striped">
        <tr>
            <th></th>
            <th>Fee</th>
            <th>Cost</th>
            <th>Quantity</th>
            <th>Payment Method</th>
        </tr>

        <?php foreach ($serviceFeeCatalog->billingForms as $key => $value) : ?>
            <tr>
                <td width="5%">
                    <?=
                    $form->field(
                        $serviceFeeCatalog->billingForms[$key],
                        "[{$key}]isActive"
                    )
                        ->checkbox(['label' => false]);
                    ?>
                </td>

                <td width="40%">
                    <?=
                    $form->field(
                        $serviceFeeCatalog->billingForms[$key],
                        "[{$key}]feeName"
                    )
                        ->label(false)
                        ->textInput(["readonly" => true]);
                    ?>
                </td>

                <td width="15%">
                    <?=
                    $form->field(
                        $serviceFeeCatalog->billingForms[$key],
                        "[{$key}]cost"
                    )
                        ->label(false)
                        ->textInput(["readonly" => true]);
                    ?>
                </td>

                <td width="10%">
                    <?=
                    $form->field(
                        $serviceFeeCatalog->billingForms[$key],
                        "[{$key}]quantity"
                    )
                        ->label(false)
                        ->textInput();
                    ?>
                </td>


                <td width="30%">
                    <?=
                    $form->field(
                        $serviceFeeCatalog->billingForms[$key],
                        "[{$key}]paymentMethod"
                    )
                        ->label(false)
                        ->dropDownList(
                            $serviceFeeCatalog->paymentMethods
                        );
                    ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>

<div class="row">
    <div class="col-sm-6 col-md-6">
        <?= Html::a(
            "Modify Payment",
            [
                "student-service-payments/registry-and-library-fees",
                "studentRegistrationId" =>
                $paymentPreview->receiptPreview->studentRegistrationId
            ],
            [
                "class" => "btn btn-block btn-warning",
            ]
        );
        ?>
    </div>

    <div class="col-sm-6 col-md-6">
        <?=
        Html::submitButton(
            "Confirm Payment",
            ["class" => "btn btn-block btn-success"]
        );
        ?>
    </div>
</div><br /><br />
<?php ActiveForm::end(); ?>