<?php

use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = $title;

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Fee Catalog", "url" => ["fees/index"]];

$this->params["breadcrumbs"][] =
    [
        "label" => "Student Fee Application Period Catalog",
        "url" => ["student-fees/view-fee-listing"]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>


<h1><?= $this->title ?></h1>

<div>
    <?php $form = ActiveForm::begin(); ?>
    <table class="table table-striped">
        <tr>
            <th></th>
            <th>Fee</th>
            <th>Cost</th>
        </tr>


        <?php foreach ($adhocBillingCharges as $key => $value) : ?>
            <tr>
                <td width="5%">
                    <?=
                    $form->field(
                        $adhocBillingCharges[$key],
                        "[{$key}]isActive"
                    )
                        ->checkbox(['label' => false]);
                    ?>
                </td>

                <td width="65%">
                    <?=
                    $form->field(
                        $adhocBillingCharges[$key],
                        "[{$key}]billingTypeName"
                    )
                        ->label(false)
                        ->textInput(["readonly" => true]);
                    ?>
                </td>

                <td width="30%">
                    <?=
                    $form->field(
                        $adhocBillingCharges[$key],
                        "[{$key}]cost"
                    )
                        ->label(false)
                        ->textInput();
                    ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>

    <?= Html::submitButton("Save", ["class" => "btn btn-success pull-right"]) ?>
    <?php ActiveForm::end(); ?>
</div><br /><br />