<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = $title;

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" => $userFullname,
        "url" => ["profiles/redirect-to-customer-profile", "username" => $username]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<div class="row">
    <div class="col-sm-4 col-md-4">
        <div class="caption text-center">
            <?=
            Html::a(
                "<h3>Scheduled Payments</h3>",
                [
                    "student-payments/scheduled-fee-report",
                    "username" => $username,
                    "studentRegistrationId" => $studentRegistrationId
                ],
                [
                    "class" => "btn btn-default btn-lg",
                    "style" => "border-width:3px"
                ]
            );
            ?>
        </div>
    </div>

    <div class="col-sm-4 col-md-4">
        <?=
        Html::a(
            "<h3>Pay registry and library fees</h3>",
            [
                "student-service-payments/registry-and-library-fees",
                "studentRegistrationId" => $studentRegistrationId
            ],
            [
                "class" => "btn btn-default btn-lg",
                "style" => "border-width:3px"
            ]
        );
        ?>
    </div>

    <div class="col-sm-4 col-md-4">
        <?=
        Html::a(
            "<h3>Graduation Payments</h3>",
            [
                "graduation-payments/view-graduation-payments",
                "username" => $username,
                "studentRegistrationId" => $studentRegistrationId,
                "studentFullName" => $userFullname
            ],
            [
                "class" => "btn btn-default btn-lg",
                "style" => "border-width:3px"
            ]
        );
        ?>
    </div>
</div>