<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = $title;

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" => $userFullname,
        "url" => ["profiles/redirect-to-customer-profile", "username" => $username]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<div class="row">
    <div class="col-sm-4 col-md-4">
        <div class="thumbnail" style="min-height:200px">
            <div class="caption text-center">
                <h3>Scheduled Payments</h3>
                <?php foreach ($studentRegistrations as $studentRegistrationId => $programme) : ?>
                    <?=
                    Html::a(
                        $programme,
                        [
                            "student-payments/scheduled-fee-report",
                            "username" => $username,
                            "studentRegistrationId" => $studentRegistrationId
                        ]
                    );
                    ?><br />
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <div class="col-sm-4 col-md-4">
        <div class="thumbnail" style="min-height:200px">
            <div class="caption text-center">
                <h3>Pay registry and library fees</h3>
                <?php foreach ($studentRegistrations as $studentRegistrationId => $programme) : ?>
                    <?=
                    Html::a(
                        $programme,
                        [
                            "student-service-payments/registry-and-library-fees",
                            "studentRegistrationId" => $studentRegistrationId
                        ]
                    );
                    ?><br />
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <div class="col-sm-4 col-md-4">
        <div class="thumbnail" style="min-height:200px">
            <div class="caption text-center">
                <h3>Graduation Payments</h3>
                <?php foreach ($studentRegistrations as $studentRegistrationId => $programme) : ?>
                    <?=
                    Html::a(
                        $programme,
                        [
                            "graduation-payments/view-graduation-payments",
                            "username" => $username,
                            "studentRegistrationId" => $studentRegistrationId,
                            "studentFullName" => $userFullname
                        ]
                    );
                    ?><br />
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>