<?php

use yii\bootstrap\ActiveForm;
use yii\helpers\Html;

$this->title = $viewModel->pageTitle;

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" => $viewModel->fullName,
        "url" =>
        [
            "profiles/redirect-to-customer-profile",
            "username" => $viewModel->username
        ]
    ];

$this->params["breadcrumbs"][] =
    [
        "label" => "Enrollment Payments",
        "url" => [
            "student-payments/scheduled-fee-report",
            "username" => $viewModel->username,
            "studentRegistrationId" => $viewModel->studentRegistrationId
        ]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<div class="panel panel-default">
    <div class="panel-body">
        <?php $form = ActiveForm::begin(); ?>

        <?=
        $form->field($viewModel->exemptionForm, "amount")
            ->textInput(["class" => "form-control"]);
        ?>

        <?=
        $form->field($viewModel->exemptionForm, "category")
            ->radioList(
                $viewModel->exemptionCategories,
                ["onClick" => "toggleNotesField()"]
            );
        ?>

        <?php if ($viewModel->exemptionForm->notes == true) : ?>
            <div id="notes-field" style="display:block">
                <?=
                $form->field($viewModel->exemptionForm, "notes")
                    ->textarea(["rows" => 5]);
                ?>
            </div>
        <?php else : ?>
            <div id="notes-field" style="display:none">
                <?=
                $form->field($viewModel->exemptionForm, "notes")
                    ->textarea(["rows" => 5]);
                ?>
            </div>
        <?php endif; ?>

        <?= Html::submitButton("Apply Exempt", ["class" => "btn btn-success pull-right"]); ?>
        <?php ActiveForm::end(); ?>
    </div>
</div>


<script>
    function toggleNotesField() {
        const exemptionCategoryField =
            document.getElementById("applyexemptionform-category");

        if (exemptionCategoryField === null) {
            //do nothing
        } else {
            let notesField = document.getElementById("notes-field");
            let selectedIndex = exemptionCategoryField.selectedIndex;
            var radio = exemptionCategoryField.getElementsByTagName("input");
            var label = exemptionCategoryField.getElementsByTagName("label");
            let selectedValue = null;
            for (var i = 0; i < radio.length; i++) {
                if (radio[i].checked) {
                    selectedValue = label[i].innerHTML;
                }
            }

            if (selectedValue.includes("Not applicable to current registration")) {
                notesField.style.display = "block";
                document.getElementById("applyexemptionform-notes").value =
                    'Not applicable to current registration.\n';
            } else if (selectedValue.includes("Payment made on comparable pre-transfer fee")) {
                notesField.style.display = "block";
                document.getElementById("applyexemptionform-notes").value =
                    'Payment made on comparable pre-transfer fee.\n';
            } else if (selectedValue.includes("Other")) {
                notesField.style.display = "block";
                document.getElementById("applyexemptionform-notes").value = "";
            } else {
                notesField.style.display = "none";
                document.getElementById("applyexemptionform-notes").value = null;
            }
        }
    }
</script>