<?php

use common\models\AcademicOfferingModel;
use kartik\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = "Student Fee Application Period Catalog";

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Fee Catalog", "url" => ["fees/index"]];

$this->params["breadcrumbs"][] = $this->title;
?>


<h1><?= $this->title ?></h1>

<?=
GridView::widget(
    [
        "dataProvider" => $dataProvider,
        "columns" => [
            [
                "attribute" => "periodName",
                "format" => "text",
                "label" => "Application Period"
            ],
            [
                "format" => "raw",
                "label" => "Fees By Programme",
                "value" => function ($row) {
                    if ($row["academicOfferings"] == false) {
                        return "";
                    } else {
                        $offerings = $row["academicOfferings"];
                        $offeringAsString = "";
                        foreach ($offerings as $offering) {
                            $name = AcademicOfferingModel::getProgrammeName(
                                $offering
                            );
                            if ($name == false) {
                                continue;
                            }
                            $url =
                                Url::to(
                                    [
                                        'view-academic-offering-fee-listing',
                                        'applicationPeriodId' => $row['applicationPeriodId'],
                                        'academicOfferingId' => $offering->academicofferingid

                                    ]
                                );
                            $offeringAsString .= "<a href={$url}>{$name}</a><br/>";
                        }
                        return $offeringAsString;
                    }
                }
            ],
            [
                "format" => "raw",
                "label" => "Fees By Cohort",
                "value" => function ($row) {
                    if ($row['status'] == "No fees entered") {
                        return Html::a(
                            "Create",
                            Url::to(
                                [
                                    "view-application-period-student-fee-dashboard",
                                    "applicationPeriodId" => $row["applicationPeriodId"]
                                ]
                            ),
                            [
                                "id" => "view-application-period-student-fee-dashboard-button",
                                "class" => "btn btn-info btn-sm"
                            ]
                        );
                    } else {
                        return Html::a(
                            "Update",
                            Url::to(
                                [
                                    "view-application-period-student-fee-dashboard",
                                    "applicationPeriodId" => $row["applicationPeriodId"]
                                ]
                            ),
                            [
                                "id" => "view-application-period-student-fee-dashboard-button",
                                "class" => "btn btn-success btn-sm"
                            ]
                        );
                    }
                }
            ],
            [
                "format" => "raw",
                "label" => "Graduation Services",
                "value" => function ($row) {
                    if ($row['graduationServiceFees'] == "No fees entered") {
                        return Html::a(
                            "Create Graduation Service Fees",
                            Url::to(
                                [
                                    "student-service-fees/catalog",
                                    "applicationPeriodId" => $row["applicationPeriodId"],
                                    "type" => "graduation"
                                ]
                            ),
                            ["class" => "btn btn-info btn-sm"]
                        );
                    } else {
                        return Html::a(
                            "Update Graduation Service Fees",
                            Url::to(
                                [
                                    "student-service-fees/catalog",
                                    "applicationPeriodId" => $row["applicationPeriodId"],
                                    "type" => "graduation"
                                ]
                            ),
                            ["class" => "btn btn-success btn-sm"]
                        );
                    }
                }
            ],
            [
                "format" => "raw",
                "label" => "Registry Services",
                "value" => function ($row) {
                    if ($row['registryServiceFees'] == "No fees entered") {
                        return Html::a(
                            "Create Registry Service Fees",
                            Url::to(
                                [
                                    "student-service-fees/catalog",
                                    "applicationPeriodId" => $row["applicationPeriodId"],
                                    "type" => "registry"
                                ]
                            ),
                            ["class" => "btn btn-info btn-sm"]
                        );
                    } else {
                        return Html::a(
                            "Update Registry Service Fees",
                            Url::to(
                                [
                                    "student-service-fees/catalog",
                                    "applicationPeriodId" => $row["applicationPeriodId"],
                                    "type" => "registry"
                                ]
                            ),
                            ["class" => "btn btn-success btn-sm"]
                        );
                    }
                }
            ],
            [
                "format" => "raw",
                "label" => "Library Services",
                "value" => function ($row) {
                    if ($row['libraryServiceFees'] == "No fees entered") {
                        return Html::a(
                            "Create Library Service Fees",
                            Url::to(
                                [
                                    "student-service-fees/catalog",
                                    "applicationPeriodId" => $row["applicationPeriodId"],
                                    "type" => "library"
                                ]
                            ),
                            ["class" => "btn btn-info btn-sm"]
                        );
                    } else {
                        return Html::a(
                            "Update Library Service Fees",
                            Url::to(
                                [
                                    "student-service-fees/catalog",
                                    "applicationPeriodId" => $row["applicationPeriodId"],
                                    "type" => "library"
                                ]
                            ),
                            ["class" => "btn btn-success btn-sm"]
                        );
                    }
                }
            ],
        ]
    ]
);
?>