<?php

use kartik\export\ExportMenu;
use kartik\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Enrolment Fee Payments';

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Report", "url" => ["reports/index"]];

$this->params["breadcrumbs"][] = $this->title;
?>

<?php if (!empty($dataProvider)) : ?>
    <div class="report-export">
        <?=
        ExportMenu::widget(
            [
                "dataProvider" => $dataProvider,
                "columns" => [
                    [
                        "attribute" => "username",
                        "format" => "text",
                        "label" => "Username"
                    ],
                    [
                        "attribute" => "firstname",
                        "format" => "text",
                        "label" => "First Name"
                    ],
                    [
                        "attribute" => "lastname",
                        "format" => "text",
                        "label" => "Last Name"
                    ],
                    [
                        "attribute" => "programme",
                        "format" => "text",
                        "label" => "Programme"
                    ],
                    [
                        "attribute" => "email",
                        "format" => "text",
                        "label" => "Email"
                    ],
                    [
                        "attribute" => "registrationStatus",
                        "format" => "text",
                        "label" => "Registration Status"
                    ],
                    [
                        "attribute" => "level",
                        "format" => "text",
                        "label" => "Level"
                    ],
                    [
                        "attribute" => "enrolmentBillingChargesTotal",
                        "format" => "text",
                        "label" => "Enrollment Total"
                    ],
                    [
                        "attribute" => "enrolmentBillingChargesPaid",
                        "format" => "text",
                        "label" => "Fees Paid"
                    ],
                    [
                        "attribute" => "outstandingEnrolmentBalance",
                        "format" => "text",
                        "label" => "Balance"
                    ],
                    [
                        "attribute" => "outstandingBillingCharges",
                        "format" => "text",
                        "label" => "Charges Outstanding"
                    ],
                ],
                'fontAwesome' => true,
                'dropdownOptions' => [
                    'label' => 'Select Export Type',
                    'class' => 'btn btn-default'
                ],
                'asDropdown' => false,
                'showColumnSelector' => false,
                'filename' => "Receipts Report",
                'exportConfig' => [
                    ExportMenu::FORMAT_TEXT => false,
                    ExportMenu::FORMAT_HTML => false,
                    ExportMenu::FORMAT_EXCEL => false,
                    ExportMenu::FORMAT_EXCEL_X => false,
                    ExportMenu::FORMAT_PDF => false
                ],
            ]
        );
        ?>
    </div><br />
<?php endif; ?>

<?=
GridView::widget(
    [
        "dataProvider" => $dataProvider,
        "columns" => [
            [
                "format" => "raw",
                "label" => "Username",
                "value" => function ($row) {
                    return Html::a(
                        $row["username"],
                        Url::to(
                            [
                                "go-to-profile",
                                "username" => $row["username"]
                            ]
                        ),
                        ["id" => "go-to-profile"]
                    );
                }
            ],
            [
                "attribute" => "firstname",
                "format" => "text",
                "label" => "First Name"
            ],
            [
                "attribute" => "lastname",
                "format" => "text",
                "label" => "Last Name"
            ],
            [
                "attribute" => "programme",
                "format" => "text",
                "label" => "Programme"
            ],
            [
                "attribute" => "registrationStatus",
                "format" => "text",
                "label" => "Registration Status"
            ],
            [
                "attribute" => "level",
                "format" => "text",
                "label" => "Level"
            ],
            [
                "attribute" => "enrolmentBillingChargesTotal",
                "format" => "text",
                "label" => "Enrollment Total"
            ],
            [
                "attribute" => "enrolmentBillingChargesPaid",
                "format" => "text",
                "label" => "Fees Paid"
            ],
            [
                "attribute" => "email",
                "format" => "text",
                "label" => "Email"
            ],
            [
                "attribute" => "outstandingEnrolmentBalance",
                "format" => "text",
                "label" => "Balance"
            ],
            [
                "attribute" => "outstandingBillingCharges",
                "format" => "text",
                "label" => "Charges Outstanding"
            ],
        ]
    ]
);
?>