<?php

use yii\helpers\Html;

?>

<div role="tabpanel" class="tab-pane active" id="student-payments">
  <div class="panel panel-default">
    <div class="panel-heading">
      <span>Payments</span>
      <span>
        <?php if ($showVoidedReceiptDisplayButton === true) : ?>
          <button id="show-student-voided-receipts-button" type="button" class="pull-right btn btn-sm btn-warning" onclick="showAllVoidedReceiptsAndHideButton()" style="margin-left:20px">
            Show Voids
          </button>
        <?php endif; ?>

        <?=
        Html::a(
          "Make Payment(s)",
          ["student-payments/payment-options", "username" => $username],
          ["class" => "btn btn-success pull-right btn-sm"]
        );
        ?>
      </span>

      <div class="panel-body">
        <div class="row">
          <div class="col-sm-12">
            <?=
            $this->render(
              "student-voided-receipts-listing",
              ["voidedReceiptsDataProvider" => $voidedReceiptsDataProvider]
            );
            ?>
          </div>
        </div>

        <div class="row">
          <div class="col-sm-12">
            <?=
            $this->render(
              "student-receipt-listing",
              [
                "dataProvider" => $dataProvider,
                "voidedReceiptsDataProvider" => $voidedReceiptsDataProvider,
                "showVoidedReceiptDisplayButton" => $showVoidedReceiptDisplayButton
              ]
            );
            ?>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script>
    function showAllVoidedReceiptsAndHideButton() {
      const toggleButton =
        document.getElementById("show-student-voided-receipts-button");

      const voidedReceiptListing =
        document.getElementById("student-voided-receipt-listing");

      const elementsExist = toggleButton != null && voidedReceiptListing != null;

      if (elementsExist == true) {
        voidedReceiptListing.style.display = "block";
        toggleButton.style.display = "none";
      }
    }

    function hideStudentVoidedReceipts() {
      const voidedReceiptListing =
        document.getElementById("student-voided-receipt-listing");

      const toggleButton =
        document.getElementById("show-student-voided-receipts-button");

      const elementsExist =
        toggleButton != null &&
        voidedReceiptListing != null;

      if (elementsExist == true) {
        toggleButton.style.display = "block";
        voidedReceiptListing.style.display = "none";
      }
    }
  </script>