<?php

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\grid\GridView;

$this->title = $viewModel->pageTitle;

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" =>  $viewModel->studentFullName,
        "url" => [
            "profiles/redirect-to-customer-profile",
            "username" => $viewModel->username
        ]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<?php if ($viewModel->changeRequestHistory == true && $viewModel->changeRequestHistory->Count > 0) : ?>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3>Package Change Request History</h3>
        </div>
        <div class="panel-body">
            <?=
            GridView::widget(
                [
                    "dataProvider" => $viewModel->changeRequestHistory,
                    "columns" => [
                        [
                            'format' => 'text',
                            'label' => 'Request Date',
                            'attribute' => 'dateCreated'
                        ],
                        [
                            'format' => 'text',
                            'label' => 'Username',
                            'attribute' => 'username'
                        ],
                        [
                            'format' => 'text',
                            'label' => 'First Name',
                            'attribute' => 'firstName'
                        ],
                        [
                            'format' => 'text',
                            'label' => 'Last Name',
                            'attribute' => 'lastName'
                        ],
                        [
                            'format' => 'raw',
                            'label' => 'Current Package',
                            'attribute' => 'currentPackage'
                        ],
                        [
                            'format' => 'raw',
                            'label' => 'Requested Package',
                            'attribute' => 'requestedPackage'
                        ],
                        [
                            'format' => 'text',
                            'label' => 'Status',
                            'attribute' => 'status'
                        ],
                        [
                            'format' => 'text',
                            'label' => 'Date Reviewed',
                            'attribute' => 'dateReviewed'
                        ]
                    ]
                ]
            );
            ?>
        </div>
    </div>
<?php endif; ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3>
            <span>Payment History</span>
            <?php if (!empty($viewModel->graduationPaymentOptions)) : ?>
                <ul class="pull-right" style="list-style-type:none">
                    <?php foreach ($viewModel->graduationPaymentOptions as $option) : ?>
                        <li style="display:inline"><?= $option ?></li>
                    <?php endforeach ?>
                </ul><br /><br />
            <?php endif ?>
        </h3>

    </div>

    <div class="panel-body">
        <?=
        GridView::widget(
            [
                "dataProvider" => $viewModel->graduationPayments,
                "columns" => [
                    [
                        "label" => "Receipt Number",
                        "format" => "raw",
                        "value" => function ($row) {
                            return Html::a(
                                $row["receiptNumber"],
                                Url::toRoute([
                                    "payments/view-receipt",
                                    "id" => $row["receiptId"],
                                    "username" => $row["username"]
                                ]),
                                [
                                    "title" => "View",
                                    "style" => "margin:0px  20px"
                                ]
                            );
                        }
                    ],
                    [
                        "attribute" => "billingTypeName",
                        "format" => "text",
                        "label" => "Billing"
                    ],
                    [
                        "attribute" => "billingTypeDescription",
                        "format" => "text",
                        "label" => "Description"
                    ],
                    [
                        "attribute" => "amount",
                        "format" => "text",
                        "label" => "Total"
                    ],
                    [
                        "attribute" => "datePaid",
                        "format" => "text",
                        "label" => "Date Paid"
                    ]
                ],
            ]
        );
        ?>
    </div>
</div>