<?php

use yii\bootstrap\ActiveForm;
use yii\helpers\Html;

$this->title = $viewModel->pageTitle;

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" => $viewModel->studentFullName,
        "url" => [
            "profiles/redirect-to-customer-profile",
            "username" => $viewModel->username
        ]
    ];

$this->params["breadcrumbs"][] =
    [
        "label" => "Graduation Payments",
        "url" => [
            "graduation-payments/view-graduation-payments",
            "username" => $viewModel->username,
            "studentRegistrationId" => $viewModel->studentRegistrationId,
            "studentFullName" => $viewModel->studentFullName
        ]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<div class="panel panel-default">
    <div class="panel-heading">
        <h4>
            <?= ($viewModel->currentPackageDetails == null) ? "No package currently selected" : "Modify {$viewModel->currentPackageDetails} Selection" ?>
        </h4>
    </div>

    <div class="panel-body">
        <?php $form = ActiveForm::begin(); ?>

        <?=
        $form->field($viewModel->form, "billingChargeId")
            ->dropDownList(
                $viewModel->packageOptions,
                ["prompt" => "Select..."]
            );
        ?>

        <?=
        Html::submitButton(
            "Save",
            ["class" => "btn btn-success pull-right"]
        );
        ?>
        <?php ActiveForm::end(); ?>
    </div>
</div>