<?php

// use dosamigos\datepicker\DatePicker;
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;

$this->title = $viewModel->pageTitle;

$this->params["breadcrumbs"][] =
    ["label" => "Bursary Dashboard", "url" => ["site/index"]];

$this->params["breadcrumbs"][] =
    ["label" => "Find Account", "url" => ["profiles/search"]];

$this->params["breadcrumbs"][] =
    [
        "label" => $viewModel->fullName,
        "url" => [
            "profiles/redirect-to-customer-profile",
            "username" => $viewModel->username
        ]
    ];

$this->params["breadcrumbs"][] =
    [
        "label" => "Graduation Payments",
        "url" => [
            "graduation-payments/view-graduation-payments",
            "username" => $viewModel->username,
            "studentRegistrationId" => $viewModel->studentRegistrationId,
            "studentFullName" => $viewModel->fullName
        ]
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<div class="btn btn-primary btn-block">
    <?= $viewModel->packageSummary ?>
</div><br />

<?php if ($viewModel->displayFeePaymentForm == true) : ?>
    <div class="panel panel-default">
        <div class="panel-body">
            <?php $form = ActiveForm::begin(); ?>
            <?=
            $form->field($viewModel->feePaymentForm, "username")
                ->textInput(["class" => "form-control", "readonly" => true]);
            ?>

            <?=
            $form->field($viewModel->feePaymentForm, "fullName")
                ->textInput(["class" => "form-control", "readonly" => true]);
            ?>

            <?=
            $form->field($viewModel->feePaymentForm, "balance")
                ->label("Amount Due")
                ->textInput(["class" => "form-control", "readonly" => true]);
            ?>

            <?=
            $form->field($viewModel->feePaymentForm, "amountPaid")
                ->label("Payment")
                ->textInput([
                    "class" => "form-control",
                    "readonly" => $viewModel->paymentAmountReadOnlyStatus
                ]);
            ?>

            <label class="control-label">Date Paid</label>
            <table style="padding:15px">
                <tr>
                    <td>
                        <?=
                        $form->field($viewModel->feePaymentForm, "dayPaid")
                            ->label(false)
                            ->dropDownList(
                                $viewModel->dayOptions,
                                ["prompt" => "Select day", "style" => "display:inline-block"]
                            );
                        ?>
                    </td>
                    <td>
                        <?=
                        $form->field($viewModel->feePaymentForm, "monthPaid")
                            ->label(false)
                            ->dropDownList(
                                $viewModel->monthOptions,
                                ["prompt" => "Select month", "style" => "display:inline-block"]
                            );
                        ?>
                    </td>
                    <td>
                        <?=
                        $form->field($viewModel->feePaymentForm, "yearPaid")
                            ->label(false)
                            ->dropDownList(
                                $viewModel->yearOptions,
                                ["prompt" => "Select year", "style" => "display:inline-block"]
                            );
                        ?>
                    </td>
                </tr>
            </table>

            <?=
            $form->field($viewModel->feePaymentForm, "paymentMethodId")
                ->inline()
                ->radioList(
                    $viewModel->paymentMethods,
                    ["onClick" => "toggleChequeNumberField()"]
                );
            ?>

            <?php if ($viewModel->feePaymentForm->chequeNumber == true) : ?>
                <div id="cheque-number-field" style="display:block">
                    <?=
                    $form->field($model, "chequeNumber")
                        ->textInput(["class" => "form-control"]);
                    ?>
                </div>
            <?php else : ?>
                <div id="cheque-number-field" style="display:none">
                    <?=
                    $form->field($viewModel->feePaymentForm, "chequeNumber")
                        ->textInput(["class" => "form-control"]);
                    ?>
                </div>
            <?php endif; ?>

            <?=
            Html::submitButton(
                "Add",
                ["class" => "btn btn-success pull-right"]
            );
            ?>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
<?php endif; ?>

<script>
    function toggleChequeNumberField() {
        const paymentMethodField =
            document.getElementById(
                "singlefeepaymentform-paymentmethodid"
            );

        if (paymentMethodField === null) {
            //do nothing
        } else {
            let chequeNumberField =
                document.getElementById("cheque-number-field");
            let selectedIndex = paymentMethodField.selectedIndex;
            var radio = paymentMethodField.getElementsByTagName("input");
            var label = paymentMethodField.getElementsByTagName("label");
            let selectedValue = null;
            for (var i = 0; i < radio.length; i++) {
                if (radio[i].checked) {
                    selectedValue = label[i].innerHTML;
                }
            }

            if (selectedValue.includes("Cheque")) {
                chequeNumberField.style.display = "block";
            } else {
                chequeNumberField.style.display = "none";
                document.getElementById(
                    "singlefeepaymentform-chequenumber"
                ).value = null;
            }
        }
    }
</script>