<?php

namespace app\subcomponents\bursary\models;

use common\models\BillingCharge;
use common\models\BillingChargeModel;
use common\models\BillingType;
use common\models\PaymentMethodModel;
use common\models\StudentRegistration;
use common\models\UserModel;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\helpers\Url;

class RegisterAndPayPackageViewModel
{
    public $username;
    public $fullName;
    public $studentRegistrationId;
    public $pageTitle;
    public $paymentMethods;
    public $paymentAmountReadOnlyStatus;
    public $packageOptions;
    public $preSelectedPackageId;
    public $preSelectedPackageName;
    public $packageSummary;
    public $displayFeePaymentForm;
    public $feePaymentForm;
    public $yearOptions;
    public $monthOptions;
    public $dayOptions;


    public function __construct(
        $username,
        $fullName,
        $studentRegistrationId,
        $pageTitle,
        $paymentMethods,
        $packageOptions,
        $preSelectedPackageId,
        $preSelectedPackageName,
        $packageSummary,
        $displayFeePaymentForm,
        $paymentAmountReadOnlyStatus,
        $feePaymentForm,
        $yearOptions,
        $monthOptions,
        $dayOptions
    ) {
        $this->username = $username;
        $this->fullName = $fullName;
        $this->studentRegistrationId = $studentRegistrationId;
        $this->pageTitle = $pageTitle;
        $this->paymentMethods = $paymentMethods;
        $this->packageOptions = $packageOptions;
        $this->preSelectedPackageId = $preSelectedPackageId;
        $this->preSelectedPackageName = $preSelectedPackageName;
        $this->packageSummary = $packageSummary;
        $this->displayFeePaymentForm = $displayFeePaymentForm;
        $this->paymentAmountReadOnlyStatus = $paymentAmountReadOnlyStatus;
        $this->feePaymentForm = $feePaymentForm;
        $this->yearOptions = $yearOptions;
        $this->monthOptions = $monthOptions;
        $this->dayOptions = $dayOptions;
    }


    private static function getYearsOptions($originYear)
    {
        $years = array();
        $currentYear = intval(date('Y'));
        for ($i = $currentYear; $i >= $originYear; $i--) {
            $year = strval($i);
            $years[$year] = $year;
        }
        return $years;
    }


    private static function getMonthOptions()
    {
        return [
            "01" => "January",
            "02" => "February",
            "03" => "March",
            "04" => "April",
            "05" => "May",
            "06" => "June",
            "07" => "July",
            "08" => "August",
            "09" => "September",
            "10" => "October",
            "11" => "November",
            "12" => "December"
        ];
    }


    private static function getDayOptions()
    {
        return [
            "01" => "01",
            "02" => "02",
            "03" => "03",
            "04" => "04",
            "05" => "05",
            "06" => "06",
            "07" => "07",
            "08" => "08",
            "09" => "09",
            "10" => "10",
            "11" => "11",
            "12" => "12",
            "13" => "13",
            "14" => "14",
            "15" => "15",
            "16" => "16",
            "17" => "17",
            "18" => "18",
            "19" => "19",
            "20" => "20",
            "21" => "21",
            "22" => "22",
            "23" => "23",
            "24" => "24",
            "25" => "25",
            "26" => "26",
            "27" => "27",
            "28" => "28",
            "29" => "29",
            "30" => "30",
            "31" => "31"
        ];
    }


    private static function generatePackageOptions($studentRegistrationId, $preselectedPackageName)
    {
        $graduationBillings =
            BillingChargeModel::getGraduationBillingsForStudentRegistration(
                $studentRegistrationId
            );

        $buttonTitle =  "";
        if ($preselectedPackageName == null) {
            $buttonTitle = "Select graduation package...";
        } else {
            $buttonTitle = "Change from  {$preselectedPackageName}...";
        }

        $unOrderedList = "<ul class='dropdown-menu'>";

        $graduationBillingCharges =
            BillingChargeModel::getActiveGraduationFees();

        if ($graduationBillings == false && !empty($graduationBillingCharges)) {
            foreach ($graduationBillingCharges as $graduationBillingCharge) {
                $billingType = BillingType::find()
                    ->where([
                        "id" => $graduationBillingCharge->billing_type_id,
                        "is_deleted" => 0
                    ])
                    ->one();
                $packageName = "{$billingType->name} ({$billingType->description})";

                $anchorElement =
                    Html::a(
                        $packageName,
                        Url::toRoute([
                            "register-and-pay-package",
                            "studentRegistrationId" => $studentRegistrationId,
                            "billingChargeId" => $graduationBillingCharge->id
                        ])
                    );

                $listElement = "<li>";
                $listElement .= $anchorElement;
                $listElement .= "</li>";
                $unOrderedList .= $listElement;
            }
        }
        $unOrderedList .= "</ul>";

        return "<span class='dropdown'>"
            . "<button class='btn btn-default dropdown-toggle btn-block' type='button' data-toggle='dropdown'>"
            . "{$buttonTitle}"
            . "<span class='caret'></span>"
            . "</button>"
            . "{$unOrderedList}"
            . "</span>";
    }


    public static function create(
        $studentRegistrationId,
        $billingChargeId
    ) {
        $studentRegistration =
            StudentRegistration::find()
            ->where(["studentregistrationid" => $studentRegistrationId])
            ->one();

        $customer = UserModel::getUserById($studentRegistration->personid);
        $fullName = UserModel::getUserFullname($customer);
        $pageTitle = "Graduation Package Payment Form";

        $paymentMethods =
            ArrayHelper::map(
                PaymentMethodModel::getActivePaymentMethods(),
                "paymentmethodid",
                "name"
            );

        $paymentAmountReadOnlyStatus = false;
        $preSelectedPackageId = $billingChargeId;

        $packageSummary = null;
        $preSelectedPackageName = null;
        $displayFeePaymentForm = false;
        $form = null;

        if ($billingChargeId == true) {
            $billingCharge =
                BillingCharge::find()
                ->where([
                    "id" => $billingChargeId,
                    "is_active" => 1,
                    "is_deleted" => 0
                ])
                ->one();
            $billingType = BillingType::find()
                ->where([
                    "id" => $billingCharge->billing_type_id,
                    "is_deleted" => 0
                ])
                ->one();
            $preSelectedPackageName = $billingType->name;

            $packageSummary = "{$billingType->name} - {$billingType->description}";

            $displayFeePaymentForm = true;

            $form = new SingleFeePaymentForm();
            $form->fillModel($customer, $fullName, $billingCharge);
        }

        $packageOptions = self::generatePackageOptions($studentRegistrationId, $preSelectedPackageName);

        $yearOptions = self::getYearsOptions(1979);
        $monthOptions = self::getMonthOptions();
        $dayOptions = self::getDayOptions();

        return new RegisterAndPayPackageViewModel(
            $customer->username,
            $fullName,
            $studentRegistrationId,
            $pageTitle,
            $paymentMethods,
            $packageOptions,
            $preSelectedPackageId,
            $preSelectedPackageName,
            $packageSummary,
            $displayFeePaymentForm,
            $paymentAmountReadOnlyStatus,
            $form,
            $yearOptions,
            $monthOptions,
            $dayOptions
        );
    }
}
