<?php

namespace app\subcomponents\bursary\models;

use common\models\Billing;
use common\models\BillingCharge;
use common\models\BillingType;
use common\models\PaymentMethodModel;
use common\models\StudentRegistration;
use common\models\UserModel;
use yii\helpers\ArrayHelper;

class ProcessPackageModificationRequestViewModel
{
    public $username;
    public $fullName;
    public $studentRegistrationId;
    public $pageTitle;
    public $paymentMethods;
    public $paymentAmountReadOnlyStatus;
    public $packageOptions;
    public $preSelectedPackageId;
    public $preSelectedPackageName;
    public $packageSummary;
    public $displayFeePaymentForm;
    public $feePaymentForm;
    public $yearOptions;
    public $monthOptions;
    public $dayOptions;


    public function __construct(
        $username,
        $fullName,
        $studentRegistrationId,
        $pageTitle,
        $paymentMethods,
        $packageOptions,
        $preSelectedPackageId,
        $preSelectedPackageName,
        $packageSummary,
        $displayFeePaymentForm,
        $paymentAmountReadOnlyStatus,
        $feePaymentForm,
        $yearOptions,
        $monthOptions,
        $dayOptions
    ) {
        $this->username = $username;
        $this->fullName = $fullName;
        $this->studentRegistrationId = $studentRegistrationId;
        $this->pageTitle = $pageTitle;
        $this->paymentMethods = $paymentMethods;
        $this->packageOptions = $packageOptions;
        $this->preSelectedPackageId = $preSelectedPackageId;
        $this->preSelectedPackageName = $preSelectedPackageName;
        $this->packageSummary = $packageSummary;
        $this->displayFeePaymentForm = $displayFeePaymentForm;
        $this->paymentAmountReadOnlyStatus = $paymentAmountReadOnlyStatus;
        $this->feePaymentForm = $feePaymentForm;
        $this->yearOptions = $yearOptions;
        $this->monthOptions = $monthOptions;
        $this->dayOptions = $dayOptions;
    }


    private static function getYearsOptions($originYear)
    {
        $years = array();
        $currentYear = intval(date('Y'));
        for ($i = $currentYear; $i >= $originYear; $i--) {
            $year = strval($i);
            $years[$year] = $year;
        }
        return $years;
    }


    private static function getMonthOptions()
    {
        return [
            "01" => "January",
            "02" => "February",
            "03" => "March",
            "04" => "April",
            "05" => "May",
            "06" => "June",
            "07" => "July",
            "08" => "August",
            "09" => "September",
            "10" => "October",
            "11" => "November",
            "12" => "December"
        ];
    }


    private static function getDayOptions()
    {
        return [
            "01" => "01",
            "02" => "02",
            "03" => "03",
            "04" => "04",
            "05" => "05",
            "06" => "06",
            "07" => "07",
            "08" => "08",
            "09" => "09",
            "10" => "10",
            "11" => "11",
            "12" => "12",
            "13" => "13",
            "14" => "14",
            "15" => "15",
            "16" => "16",
            "17" => "17",
            "18" => "18",
            "19" => "19",
            "20" => "20",
            "21" => "21",
            "22" => "22",
            "23" => "23",
            "24" => "24",
            "25" => "25",
            "26" => "26",
            "27" => "27",
            "28" => "28",
            "29" => "29",
            "30" => "30",
            "31" => "31"
        ];
    }


    private static function getDefaultPaymentAmount(
        $packageModificationRequest
    ) {

        $proposedPackage =
            BillingCharge::find()
            ->where([
                "id" => $packageModificationRequest->proposed_package_id,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->one();

        $totalOfCurrentPackagePaid = 0;

        $graduationBillings =
            Billing::find()
            ->innerJoin(
                'billing_charge',
                '`billing`.`billing_charge_id` = `billing_charge`.`id`'
            )
            ->innerJoin(
                'billing_type',
                '`billing_charge`.`billing_type_id` = `billing_type`.`id`'
            )->innerJoin(
                'billing_category',
                '`billing_type`.`billing_category_id` = `billing_category`.`id`'
            )
            ->where([
                "billing_charge.id" => $packageModificationRequest->current_package_id,
                "billing.student_registration_id" => $packageModificationRequest->student_registration_id,
                "billing.is_active" => 1,
                "billing.is_deleted" => 0,
                "billing_category.name" => "Graduation Services"
            ])
            ->all();
        foreach ($graduationBillings as $graduationBilling) {
            $totalOfCurrentPackagePaid += $graduationBilling->amount_paid;
        }
        return $proposedPackage->cost - $totalOfCurrentPackagePaid;
    }


    private static function determinePaymentAmountReadOnlyStatus(
        $packageModificationRequest
    ) {
        $paymentAmountReadOnlyStatus = false;

        $proposedPackage =
            BillingCharge::find()
            ->where([
                "id" => $packageModificationRequest->proposed_package_id,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->one();
        $proposedCost = $proposedPackage->cost;

        $currentPackage =
            BillingCharge::find()
            ->where([
                "id" => $packageModificationRequest->current_package_id,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->one();
        $currentCost = $currentPackage->cost;

        $totalOfCurrentPackagePaid = 0;
        $graduationBillings =
            Billing::find()
            ->innerJoin(
                'billing_charge',
                '`billing`.`billing_charge_id` = `billing_charge`.`id`'
            )
            ->innerJoin(
                'billing_type',
                '`billing_charge`.`billing_type_id` = `billing_type`.`id`'
            )->innerJoin(
                'billing_category',
                '`billing_type`.`billing_category_id` = `billing_category`.`id`'
            )
            ->where([
                "billing_charge.id" => $packageModificationRequest->current_package_id,
                "billing.student_registration_id" => $packageModificationRequest->student_registration_id,
                "billing.is_active" => 1,
                "billing.is_deleted" => 0,
                "billing_category.name" => "Graduation Services"
            ])
            ->all();
        foreach ($graduationBillings as $graduationBilling) {
            $totalOfCurrentPackagePaid += $graduationBilling->amount_paid;
        }
        $paidInFull = $currentCost == $totalOfCurrentPackagePaid ? true : false;

        if ($paidInFull == true && $proposedCost <= $currentCost) {
            $paymentAmountReadOnlyStatus = true;
        } elseif ($paidInFull == false && $totalOfCurrentPackagePaid >= $proposedCost) {
            $paymentAmountReadOnlyStatus = true;
        } else {
            $paymentAmountReadOnlyStatus = false;
        }

        return $paymentAmountReadOnlyStatus;
    }


    public static function create($packageModificationRequest)
    {
        $studentRegistration =
            StudentRegistration::find()
            ->where([
                "studentregistrationid" => $packageModificationRequest->student_registration_id
            ])
            ->one();

        $customer = UserModel::getUserById($studentRegistration->personid);
        $fullName = UserModel::getUserFullname($customer);
        $pageTitle = "Graduation Package Payment Form";

        $paymentMethods =
            ArrayHelper::map(
                PaymentMethodModel::getActivePaymentMethods(),
                "paymentmethodid",
                "name"
            );

        $preSelectedPackageId = $packageModificationRequest->proposed_package_id;

        $proposedPackage =
            BillingCharge::find()
            ->where([
                "id" => $packageModificationRequest->proposed_package_id,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->one();

        $billingType = BillingType::find()
            ->where([
                "id" => $proposedPackage->billing_type_id,
                "is_deleted" => 0
            ])
            ->one();
        $preSelectedPackageName = $billingType->name;

        $packageSummary = "{$billingType->name} - {$billingType->description}";

        $displayFeePaymentForm = true;

        $paymentAmountReadOnlyStatus =
            self::determinePaymentAmountReadOnlyStatus(
                $packageModificationRequest
            );

        $packageOptions = null;

        $maxPayableOnProposedBillingCharge =
            self::getDefaultPaymentAmount($packageModificationRequest);

        $form = new SingleFeePaymentForm();
        $form->buildForGraduationPackageModification(
            $customer,
            $fullName,
            $proposedPackage,
            $maxPayableOnProposedBillingCharge
        );

        $yearOptions = self::getYearsOptions(1979);
        $monthOptions = self::getMonthOptions();
        $dayOptions = self::getDayOptions();

        return new ProcessPackageModificationRequestViewModel(
            $customer->username,
            $fullName,
            $packageModificationRequest->student_registration_id,
            $pageTitle,
            $paymentMethods,
            $packageOptions,
            $preSelectedPackageId,
            $preSelectedPackageName,
            $packageSummary,
            $displayFeePaymentForm,
            $paymentAmountReadOnlyStatus,
            $form,
            $yearOptions,
            $monthOptions,
            $dayOptions
        );
    }
}
