<?php

namespace app\subcomponents\bursary\models;

use common\models\ErrorObject;
use common\models\Billing;
use common\models\Receipt;
use common\models\ReceiptModel;
use common\models\UserModel;
use common\models\GraduationSurvey;

class PreviewGraduationReceiptViewModel
{
    public $pageTitle;
    public $username;
    public $studentRegistrationId;
    public $fullName;
    public $receipt;
    public $billings;
    public $total;
    public $operator;
    public $paymentMethod;

    public function __construct(
        $pageTitle,
        $username,
        $studentRegistrationId,
        $fullName,
        $receipt,
        $billings,
        $total,
        $operator,
        $paymentMethod
    ) {
        $this->pageTitle = $pageTitle;
        $this->username = $username;
        $this->studentRegistrationId = $studentRegistrationId;
        $this->fullName = $fullName;
        $this->receipt = $receipt;
        $this->billings = $billings;
        $this->total = $total;
        $this->operator = $operator;
        $this->paymentMethod = $paymentMethod;
    }


    public static function create(
        $receiptId,
        $studentRegistrationId
    ) {
        $pageTitle = "Graduation Payments";
        $receipt = Receipt::find()->where(["id" => $receiptId])->one();
        $billings = Billing::find()->where(["receipt_id" => $receipt->id])->all();
        $customer = UserModel::getUserById($receipt->customer_id);
        $fullName = UserModel::getUserFullname($customer);
        $username = $customer->username;

        $billingsTotal = 0;
        foreach ($billings as $billing) {
            $billingsTotal += ($billing->amount_paid * $billing->quantity);
        }
        $total = number_format($billingsTotal, 2);

        $user = UserModel::getUserById($receipt->created_by);
        $operator = ReceiptModel::getOperatorCode($user);
        $paymentMethod = ReceiptModel::getPaymentMethod($receipt);

        return new PreviewGraduationReceiptViewModel(
            $pageTitle,
            $username,
            $studentRegistrationId,
            $fullName,
            $receipt,
            $billings,
            $total,
            $operator,
            $paymentMethod
        );
    }


    // public function approvePayment($receiptId)
    // {
    //     $receipt = Receipt::find()->where(["id" => $receiptId])->one();

    //     if ($receipt == false) {
    //         return new ErrorObject("Error ocurred finding receipt model");
    //     }

    //     $billings =
    //         Billing::find()
    //         ->where(["receipt_id" => $receipt->id])
    //         ->all();

    //     if ($billings == false) {
    //         return new ErrorObject("Error ocurred finding billings ");
    //     }

    //     foreach ($billings as $billing) {
    //         $billing->is_active = 1;
    //         $billing->is_deleted = 0;
    //         if ($billing->save() == false) {
    //             return new ErrorObject("Error ocurred approving billing");
    //         }
    //     }

    //     $receipt->publish_count += 1;
    //     $receipt->is_active = 1;
    //     $receipt->is_deleted = 0;

    //     if ($receipt->save() == false) {
    //         return new ErrorObject("Error ocurred approving receipt");
    //     }
    //     return true;
    // }

    private function getStaffRespondentGraduationSurvey($receiptId)
    {
        $receipt = Receipt::find()->where(["id" => $receiptId])->one();

        return GraduationSurvey::find()
            ->where([
                "student_registration_id" => $receipt->student_registration_id,
                "respondent_id" => $receipt->created_by,
                "is_deleted" => 1
            ])
            ->one();
    }


    public function approvePayment($receiptId)
    {
        $receipt = Receipt::find()->where(["id" => $receiptId])->one();

        if ($receipt == false) {
            return new ErrorObject("Error ocurred finding receipt model");
        }

        $billings =
            Billing::find()
            ->where(["receipt_id" => $receipt->id])
            ->all();

        if ($billings == false) {
            return new ErrorObject("Error ocurred finding billings ");
        }

        foreach ($billings as $billing) {
            $billing->is_active = 1;
            $billing->is_deleted = 0;
            if ($billing->save() == false) {
                return new ErrorObject("Error ocurred approving billing");
            }
        }

        $receipt->publish_count += 1;
        $receipt->is_active = 1;
        $receipt->is_deleted = 0;

        if ($receipt->save() == false) {
            return new ErrorObject("Error ocurred approving receipt");
        }

        $graduationSurvey = $this->getStaffRespondentGraduationSurvey($receiptId);
        if ($graduationSurvey == true) {
            $graduationSurvey->is_deleted = 0;
            if ($graduationSurvey->save() == false) {
                return new ErrorObject("Error ocurred approving graduation survey");
            }
        }

        return true;
    }
}
