<?php

namespace app\subcomponents\bursary\models;

use common\models\Billing;
use common\models\BillingCharge;
use common\models\BillingType;
use common\models\Receipt;
use common\models\GraduationSurvey;
use common\models\GraduationPackageChangeRequest;

class PackageModificationRequestEntryViewModel
{
    public $pageTitle;
    public $username;
    public $studentRegistrationId;
    public $studentFullName;
    public $currentPackageDetails;
    public $form;
    public $packageOptions;
    public $billingChargeId;

    public function __construct(
        $pageTitle,
        $username,
        $studentRegistrationId,
        $studentFullName,
        $currentPackageDetails,
        $form,
        $packageOptions,
        $billingChargeId
    ) {
        $this->pageTitle = $pageTitle;
        $this->username = $username;
        $this->studentRegistrationId = $studentRegistrationId;
        $this->studentFullName = $studentFullName;
        $this->currentPackageDetails = $currentPackageDetails;
        $this->form = $form;
        $this->packageOptions = $packageOptions;
        $this->billingChargeId = $billingChargeId;
    }


    public static function createPostPaymentRequest(
        $username,
        $studentRegistrationId,
        $studentFullName
    ) {
        $pageTitle = "Package Modification";

        $graduationReceipts =
            Receipt::find()
            ->innerJoin(
                'billing',
                '`billing`.`receipt_id` = `receipt`.`id`'
            )
            ->innerJoin(
                'billing_charge',
                '`billing`.`billing_charge_id` = `billing_charge`.`id`'
            )
            ->innerJoin(
                'billing_type',
                '`billing_charge`.`billing_type_id` = `billing_type`.`id`'
            )->innerJoin(
                'billing_category',
                '`billing_type`.`billing_category_id` = `billing_category`.`id`'
            )
            ->where([
                "receipt.student_registration_id" => $studentRegistrationId,
                "receipt.is_active" => 1,
                "receipt.is_deleted" => 0,
                "billing_category.name" => "Graduation Services"
            ])
            ->all();

        $graduationBilling =
            Billing::find()
            ->where(["receipt_id" => $graduationReceipts[0]->id])
            ->one();

        $graduationPaymentType =
            $graduationBilling->getBillingCharge()->one()->getBillingType()->one();

        $currentPackageDetails = "{$graduationPaymentType->name}";

        $form = new GraduationPackageModificationForm();

        $packageOptions =
            self::generatePackageOptions($graduationBilling->billing_charge_id);

        $billingChargeId = $graduationBilling->billing_charge_id;

        return new PackageModificationRequestEntryViewModel(
            $pageTitle,
            $username,
            $studentRegistrationId,
            $studentFullName,
            $currentPackageDetails,
            $form,
            $packageOptions,
            $billingChargeId
        );
    }

    private static function generatePackageOptions($currentBillingChargeId = null)
    {
        $availableGraduationBillingCharges = null;
        if ($currentBillingChargeId == null) {
            $availableGraduationBillingCharges =
                BillingCharge::find()
                ->innerJoin(
                    "billing_type",
                    "`billing_charge`.`billing_type_id` = `billing_type`.`id`"
                )
                ->innerJoin(
                    "billing_category",
                    "`billing_type`.`billing_category_id` = `billing_category`.`id`"
                )
                ->innerJoin(
                    "application_period",
                    "`billing_charge`.`application_period_id` = `application_period`.`applicationperiodid`"
                )
                ->innerJoin(
                    "academic_year",
                    "`application_period`.`academicyearid` = `academic_year`.`academicyearid`"
                )
                ->where([
                    "billing_charge.is_active" => 1,
                    "billing_charge.is_deleted" => 0,
                    "billing_category.name" => "Graduation Services",
                    "application_period.divisionid" => 4,
                    "application_period.isactive" => 1,
                    "application_period.isdeleted" => 0,
                    "academic_year.iscurrent" => 1
                ])
                ->all();
        } else {
            $availableGraduationBillingCharges =
                BillingCharge::find()
                ->innerJoin(
                    "billing_type",
                    "`billing_charge`.`billing_type_id` = `billing_type`.`id`"
                )
                ->innerJoin(
                    "billing_category",
                    "`billing_type`.`billing_category_id` = `billing_category`.`id`"
                )
                ->innerJoin(
                    "application_period",
                    "`billing_charge`.`application_period_id` = `application_period`.`applicationperiodid`"
                )
                ->innerJoin(
                    "academic_year",
                    "`application_period`.`academicyearid` = `academic_year`.`academicyearid`"
                )
                ->where([
                    "billing_charge.is_active" => 1,
                    "billing_charge.is_deleted" => 0,
                    "billing_category.name" => "Graduation Services",
                    "application_period.divisionid" => 4,
                    "application_period.isactive" => 1,
                    "application_period.isdeleted" => 0,
                    "academic_year.iscurrent" => 1
                ])
                ->andWhere([
                    "not",
                    ["billing_charge.id" => $currentBillingChargeId]
                ])
                ->all();
        }

        $packageOptions = array();
        if ($availableGraduationBillingCharges == true) {
            foreach ($availableGraduationBillingCharges as $billingCharge) {
                $id = $billingCharge->id;
                $billingType = BillingType::find()
                    ->where([
                        "id" => $billingCharge->billing_type_id,
                        "is_deleted" => 0
                    ])
                    ->one();
                $packageName = "{$billingType->name} ({$billingType->description})";
                $packageOptions[$id] = $packageName;
            }
        }
        return $packageOptions;
    }


    public static function createPrePaymentRequest(
        $username,
        $studentRegistrationId,
        $studentFullName
    ) {
        $pageTitle = "Package Request";

        $graduationSurvey =
            GraduationSurvey::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "is_deleted" => 0
            ])
            ->one();

        // Approved change requests take precedence of graduation survey
        // As multiple approved changed request can exist you must use most recent approved request
        $approvedChangeRequests = GraduationPackageChangeRequest::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "is_active" => 1,
                "is_deleted" => 0,
                "graduation_package_change_request_status_id" => 2
            ])
            ->orderBy("id DESC")
            ->all();
        if ($approvedChangeRequests == true) {
            $activePackage =
                BillingCharge::find()
                ->where([
                    "id" => $approvedChangeRequests[0]->proposed_package_id,
                    "is_active" => 1,
                    "is_deleted" => 0
                ])
                ->one();

            $graduationPaymentType = $activePackage->getBillingType()->one();
            $currentPackageDetails = "{$graduationPaymentType->name}";
            $form = new GraduationPackageModificationForm();
            $packageOptions = self::generatePackageOptions($activePackage->id);
            $billingChargeId = $activePackage->id;

            return new PackageModificationRequestEntryViewModel(
                $pageTitle,
                $username,
                $studentRegistrationId,
                $studentFullName,
                $currentPackageDetails,
                $form,
                $packageOptions,
                $billingChargeId
            );
        } elseif ($graduationSurvey == true && $graduationSurvey->billing_charge_id !== null) {
            $activePackage =
                BillingCharge::find()
                ->where([
                    "id" => $graduationSurvey->billing_charge_id,
                    "is_active" => 1,
                    "is_deleted" => 0
                ])
                ->one();

            $graduationPaymentType =
                $activePackage->getBillingType()->one();

            $currentPackageDetails = "{$graduationPaymentType->name}";

            $form = new GraduationPackageModificationForm();

            $packageOptions =
                self::generatePackageOptions($graduationSurvey->billing_charge_id);

            $billingChargeId = $graduationSurvey->billing_charge_id;

            return new PackageModificationRequestEntryViewModel(
                $pageTitle,
                $username,
                $studentRegistrationId,
                $studentFullName,
                $currentPackageDetails,
                $form,
                $packageOptions,
                $billingChargeId
            );
        } else {
            $currentPackageDetails = null;
            $form = new GraduationPackageModificationForm();
            $packageOptions = self::generatePackageOptions();
            $billingChargeId = null;

            return new PackageModificationRequestEntryViewModel(
                $pageTitle,
                $username,
                $studentRegistrationId,
                $studentFullName,
                $currentPackageDetails,
                $form,
                $packageOptions,
                $billingChargeId
            );
        }
    }
}
