<?php

namespace app\subcomponents\bursary\models;

class GraduationPayment
{
    public $username;
    public $receiptId;
    public $receiptNumber;
    public $billingChargeId;
    public $billingTypeName;
    public $billingTypeDescription;
    public $amount;
    public $datePaid;


    public function __construct(
        $username,
        $receiptId,
        $receiptNumber,
        $billingChargeId,
        $billingTypeName,
        $billingTypeDescription,
        $amount,
        $datePaid
    ) {
        $this->username = $username;
        $this->receiptId = $receiptId;
        $this->receiptNumber = $receiptNumber;
        $this->billingChargeId = $billingChargeId;
        $this->billingTypeName = $billingTypeName;
        $this->billingTypeDescription = $billingTypeDescription;
        $this->amount = $amount;
        $this->datePaid = $datePaid;
    }


    public static function create($receipt, $billing)
    {
        $receiptId = $receipt->id;
        $receiptNumber = $receipt->receipt_number;
        $billingChargeId = $billing->getBillingCharge()->one()->id;
        $billingType = $billing->getBillingCharge()->one()->getBillingType()->one();
        $billingTypeName = $billingType->name;
        $billingTypeDescription = $billingType->description;

        $amount = $billing->amount_paid;
        $datePaid = date_format(new \DateTime($receipt->date_paid), "F j, Y");

        return new GraduationPayment(
            $receipt->username,
            $receiptId,
            $receiptNumber,
            $billingChargeId,
            $billingTypeName,
            $billingTypeDescription,
            $amount,
            $datePaid
        );
    }
}
