<?php

namespace app\subcomponents\bursary\models;

use common\models\BillingCharge;
use common\models\GraduationPackageChangeRequestStatus;
use common\models\UserModel;

class GraduationPackageChangeRequestSummary
{
    public $currentPackageDescription;
    public $proposedPackageDescription;
    public $costDifference;
    public $requestStatus;
    public $createdBy;
    public $dateCreated;
    public $reviewedBy;
    public $dateReviewed;

    private function __construct(
        $currentPackageDescription,
        $proposedPackageDescription,
        $costDifference,
        $requestStatus,
        $createdBy,
        $dateCreated,
        $reviewedBy,
        $dateReviewed
    ) {
        $this->currentPackageDescription = $currentPackageDescription;
        $this->proposedPackageDescription = $proposedPackageDescription;
        $this->costDifference = $costDifference;
        $this->requestStatus = $requestStatus;
        $this->createdBy = $createdBy;
        $this->dateCreated = $dateCreated;
        $this->reviewedBy = $reviewedBy;
        $this->dateReviewed = $dateReviewed;
    }

    public static function create($graduationPackageChangeRequest)
    {
        $currentPackage =
            BillingCharge::find()
            ->where([
                "id" => $graduationPackageChangeRequest->current_package_id,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->one();

        if ($currentPackage == true) {
            $currentPackageName = $currentPackage->getBillingType()->one()->name;
            $currentPackageDescription =
                "{$currentPackageName}" . " $" . "({$currentPackage->cost})";

            $proposedPackage =
                BillingCharge::find()
                ->where([
                    "id" => $graduationPackageChangeRequest->proposed_package_id,
                    "is_active" => 1,
                    "is_deleted" => 0
                ])
                ->one();
            $proposedPackageName = $proposedPackage->getBillingType()->one()->name;
            $proposedPackageDescription =
                "{$proposedPackageName}" . " $" . "({$proposedPackage->cost})";

            $costDifference = "$" . strval($proposedPackage->cost - $currentPackage->cost);

            $requestStatus =
                GraduationPackageChangeRequestStatus::find()
                ->where([
                    "id" => $graduationPackageChangeRequest->graduation_package_change_request_status_id
                ])
                ->one()
                ->name;

            $creator =
                UserModel::findUserByID($graduationPackageChangeRequest->created_by);
            $createdBy = UserModel::getUserFullname($creator);

            $dateCreated =
                date_format(
                    date_create($graduationPackageChangeRequest->date_created),
                    "d/m/Y"
                );

            $reviewedBy = "N/A";
            if ($graduationPackageChangeRequest->reviewed_by == true) {
                $reviewer =
                    UserModel::findUserByID(
                        $graduationPackageChangeRequest->reviewed_by
                    );
                $reviewedBy = UserModel::getUserFullname($reviewer);
            }

            $dateReviewed = "N/A";
            if ($graduationPackageChangeRequest->date_reviewed == true) {
                $dateReviewed =
                    date_format(
                        date_create($graduationPackageChangeRequest->date_reviewed),
                        "d/m/Y"
                    );
            }

            return new GraduationPackageChangeRequestSummary(
                $currentPackageDescription,
                $proposedPackageDescription,
                $costDifference,
                $requestStatus,
                $createdBy,
                $dateCreated,
                $reviewedBy,
                $dateReviewed
            );
        } else {
            $currentPackageName = null;
            $currentPackageDescription = null;

            $proposedPackage =
                BillingCharge::find()
                ->where([
                    "id" => $graduationPackageChangeRequest->proposed_package_id,
                    "is_active" => 1,
                    "is_deleted" => 0
                ])
                ->one();
            $proposedPackageName = $proposedPackage->getBillingType()->one()->name;
            $proposedPackageDescription =
                "{$proposedPackageName}" . " $" . "({$proposedPackage->cost})";

            $costDifference = null;

            $requestStatus =
                GraduationPackageChangeRequestStatus::find()
                ->where([
                    "id" => $graduationPackageChangeRequest->graduation_package_change_request_status_id
                ])
                ->one()
                ->name;

            $creator =
                UserModel::findUserByID($graduationPackageChangeRequest->created_by);
            $createdBy = UserModel::getUserFullname($creator);

            $dateCreated =
                date_format(
                    date_create($graduationPackageChangeRequest->date_created),
                    "d/m/Y"
                );

            $reviewedBy = "N/A";
            if ($graduationPackageChangeRequest->reviewed_by == true) {
                $reviewer =
                    UserModel::findUserByID(
                        $graduationPackageChangeRequest->reviewed_by
                    );
                $reviewedBy = UserModel::getUserFullname($reviewer);
            }

            $dateReviewed = "N/A";
            if ($graduationPackageChangeRequest->date_reviewed == true) {
                $dateReviewed =
                    date_format(
                        date_create($graduationPackageChangeRequest->date_reviewed),
                        "d/m/Y"
                    );
            }

            return new GraduationPackageChangeRequestSummary(
                $currentPackageDescription,
                $proposedPackageDescription,
                $costDifference,
                $requestStatus,
                $createdBy,
                $dateCreated,
                $reviewedBy,
                $dateReviewed
            );
        }
    }

    public function toString()
    {
        return "Current Package - {$this->currentPackageDescription}\n"
            . "Proposed Package - {$this->proposedPackageDescription}\n"
            . "Cost Difference - {$this->costDifference}\n"
            . "Request Status - {$this->requestStatus}\n"
            . "Created By - {$this->createdBy}\n"
            . "Date Created - {$this->dateCreated}\n"
            . "Reviewed By - {$this->reviewedBy}\n"
            . "Date Reviewed - {$this->dateReviewed}\n";
    }
}
