<?php

namespace app\subcomponents\bursary\models;

use common\models\BillingCharge;

class GraduationOperationValidator
{
    public static function canRegisterAndPayPackage($graduationSurvey, $activeChangeRequest, $graduationBillings)
    {
        if ($graduationSurvey == false && empty($graduationBillings) && $activeChangeRequest == false) {
            return true;
        }
        return false;
    }


    /**
     * Undocumented function
     *
     * Student cant be allowed to PAyInstallment in this way is GraduationSurvey is false
     * because if at some point it was false, the only option available to them would 
     * have been RegisterAndPay option, which creates a GraduationSurvey record. So even
     * if this is the case and the entire fee was not paid a GraduationSurvey record would now exist.
     * @param [type] $graduationSurvey
     * @param [type] $activeChangeRequest
     * @param [type] $graduationBillings
     * @return boolean
     */
    public static function canMakePayment($graduationSurvey, $activeChangeRequest, $graduationBillings)
    {
        if (
            /**
             * Most likely scenario when student has indicated their will to participate
             */
            ($graduationSurvey == true
                && $graduationSurvey->will_participate == true
                && $graduationSurvey->billing_charge_id !== null
                && $activeChangeRequest == false
                && (empty($graduationBillings) == true
                    || self::graduationPaymentDue($graduationBillings, $activeChangeRequest) == true
                )
            )
            ||
            /**
             * If student responded to survey (negative or positive) but subsequently indicated
             * submitted change request which was subsequently approved by Registry
             */
            ($graduationSurvey == true
                && $graduationSurvey->will_participate !== null
                && $activeChangeRequest == true
                && $activeChangeRequest->graduation_package_change_request_status_id == 2
                && (empty($graduationBillings) == true
                    || self::graduationPaymentDue($graduationBillings, $activeChangeRequest) == true
                )
            )
        ) {
            return true;
        }
        return false;
    }


    public static function canCreatePrePaymentChangeRequest($graduationSurvey, $activeChangeRequest, $graduationBillings)
    {
        if (
            $graduationSurvey == true
            && $graduationSurvey->will_participate !== null
            && (
                ($activeChangeRequest == true && $activeChangeRequest->graduation_package_change_request_status_id != 1)
                || ($activeChangeRequest == false)
            )
            && empty($graduationBillings)
        ) {
            return true;
        }
        return false;
    }


    public static function canCreatePostPaymentChangeRequest($graduationBillings, $activeChangeRequest)
    {
        if (!empty($graduationBillings) && $activeChangeRequest == false) {
            return true;
        }
        return false;
    }


    /**
     * Only true if at least one installment exists and there is a balance due on fee total.
     *
     * @param [type] $graduationBillings
     * @param [type] $activeChangeRequest
     * @return bool
     */
    private static function graduationPaymentDue($graduationBillings, $activeChangeRequest)
    {
        if (empty($graduationBillings)) {
            return false;
        }

        $totalGraduationPayments = 0;
        foreach ($graduationBillings as $graduationBilling) {
            $totalGraduationPayments += $graduationBilling->amount_paid;
        }

        $graduationPackageBillingCharge = null;
        if ($activeChangeRequest == true && $activeChangeRequest->graduation_package_change_request_status_id == 2) {
            $graduationPackageBillingCharge =
                BillingCharge::find()
                ->where(["id" => $activeChangeRequest->proposed_package_id])
                ->one();
        } else {
            $graduationPackageBillingCharge =
                BillingCharge::find()
                ->where(["id" => end($graduationBillings)->billing_charge_id])
                ->one();
        }

        if ($graduationPackageBillingCharge->cost - $totalGraduationPayments > 0) {
            return true;
        } else {
            return false;
        }
    }
}
