<?php

namespace app\subcomponents\bursary\models;

use common\models\BillingChargeModel;
use common\models\BillingCharge;
use common\models\BillingType;
use common\models\PaymentMethodModel;
use common\models\StudentRegistration;
use common\models\UserModel;
use yii\helpers\ArrayHelper;

class ApplyExemptionViewModel
{
    public $pageTitle;
    public $username;
    public $fullName;
    public $studentRegistrationId;
    public $exemptionForm;
    public $exemptionCategories;

    public function __construct(
        $pageTitle,
        $username,
        $fullName,
        $studentRegistrationId,
        $exemptionForm,
        $exemptionCategories
    ) {
        $this->pageTitle = $pageTitle;
        $this->username = $username;
        $this->fullName = $fullName;
        $this->studentRegistrationId = $studentRegistrationId;
        $this->exemptionForm = $exemptionForm;
        $this->exemptionCategories = $exemptionCategories;
    }


    private static function getDefaultExemptionAmount($billingChargeId)
    {
        $billingCharge =
            BillingCharge::find()
            ->where([
                "id" => $billingChargeId,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->one();
        return $billingCharge->cost;
    }

    private static function fillNotes($existingNotes)
    {
        $notes = null;
        if ($existingNotes == true) {
            $notes = $existingNotes;
        }
        return $notes;
    }

    private static function getExemptionCategories()
    {
        $categories = array();

        $categories["Not applicable to current registration"] =
            "Not applicable to current registration";

        $categories["Payment made on comparable pre-transfer fee"] =
            "Payment made on comparable pre-transfer fee";

        $categories["Other"] = "Other";
        return $categories;
    }

    private static function getPagTitle($billingChargeId)
    {
        $billingCharge =
            BillingCharge::find()
            ->where([
                "id" => $billingChargeId,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->one();

        $billingName = BillingChargeModel::getBillingChargeFeeName($billingCharge);

        return "Apply Exemption To {$billingName} Fee";
    }

    public static function create(
        $username,
        $studentRegistrationId,
        $billingChargeId,
        $svgccPersonnelId
    ) {
        $pageTitle = self::getPagTitle($billingChargeId);

        $studentRegistration =
            StudentRegistration::find()
            ->where(["studentregistrationid" => $studentRegistrationId])
            ->one();
        $userAccount = UserModel::getUserById($studentRegistration->personid);
        $fullName = UserModel::getUserFullname($userAccount);

        $exemptionCategories = self::getExemptionCategories();

        $exemptionForm = new ApplyExemptionForm();
        $exemptionForm->billingChargeId = $billingChargeId;
        $exemptionForm->studentRegistrationId = $studentRegistrationId;
        $exemptionForm->creditId = null;
        $exemptionForm->appliedBy = $svgccPersonnelId;
        $exemptionForm->appliedTimestamp = date("Y-m-d H:i:s");
        $exemptionForm->amount = self::getDefaultExemptionAmount($billingChargeId);
        $exemptionForm->notes = self::fillNotes($exemptionForm->notes);
        $exemptionForm->isDeleted = 0;


        return new ApplyExemptionViewModel(
            $pageTitle,
            $username,
            $fullName,
            $studentRegistrationId,
            $exemptionForm,
            $exemptionCategories
        );
    }
}
