<?php

namespace app\subcomponents\bursary\models;

use common\models\BillingCharge;
use common\models\BillingChargeExemption;
use common\models\BillingModel;
use common\models\Credit;
use common\models\ErrorObject;
use yii\base\Model;


class ApplyExemptionForm extends Model
{
    public $billingChargeId;
    public $studentRegistrationId;
    public $creditId;
    public $appliedBy;
    public $appliedTimestamp;
    public $amount;
    public $category;
    public $notes;
    public $isDeleted;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [
                [
                    "billingChargeId",
                    "studentRegistrationId",
                    "creditId",
                    "appliedBy",
                    "appliedTimeStamp",
                    "amount",
                    "notes",
                    "isDeleted",
                    "category"
                ],
                "required"
            ],
            [["amount"], "number"],
            [["notes", "category"], "string"],

            [
                [
                    "isDeleted",
                    "billingChargeId",
                    "studentRegistrationId",
                    "creditId",
                    "appliedBy",
                ],
                "integer"
            ],
            [["appliedTimeStamp"], "safe"]
        ];
    }


    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            "billingChargeId" => "Billing Charge",
            "studentRegistrationId" => "Student Registration",
            "creditId" => "Credit ID",
            "appliedBy" => "SVGCC Personnel",
            "appliedTimeStamp" => "Timestamp",
            "amount" => "Amount",
            "notes" => "Notes",
            "isDeleted" => "Record Deleted",
            "category" => "Exemption Category"
        ];
    }

    public function createExemption()
    {
        $billingChargeExemption = new BillingChargeExemption();
        $billingChargeExemption->billing_charge_id = $this->billingChargeId;
        $billingChargeExemption->student_registration_id = $this->studentRegistrationId;
        $billingChargeExemption->credit_id = null;
        $billingChargeExemption->applied_by = $this->appliedBy;
        $billingChargeExemption->applied_timestamp = $this->appliedTimestamp;
        $billingChargeExemption->amount = $this->amount;
        $billingChargeExemption->notes = $this->notes;
        $billingChargeExemption->is_deleted = 0;

        if ($billingChargeExemption->validate() == true) {
            return $billingChargeExemption;
        } else {
            return new ErrorObject("Error ocurred generating exemption");
        }
    }

    public function createCredit($personId)
    {
        $credit = new Credit();
        $credit->student_registration_id = $this->studentRegistrationId;
        $credit->person_id = $personId;

        $billingCharge =
            BillingCharge::find()
            ->where([
                "id" => $this->billingChargeId,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->one();
        $amountRefundable = $billingCharge->cost;

        $billings =
            BillingModel::getCustomerFeePayments(
                $this->billingChargeId,
                $personId
            );

        if (!empty($billings)) {
            $amountRefundable = 0;
            foreach ($billings as $billing) {
                $amountRefundable += $billing->amount_paid;
            }
        }

        $credit->amount = $amountRefundable;
        $credit->date_applied = date("Y-m-d H:i:s");;
        $credit->applied_by = $this->appliedBy;

        $credit->details =
            "Credit generated as a result of the fee exemption being applied to"
            . " fee that student has already started making payment towards.\n";

        $credit->credit_type_id = 1;
        $credit->was_refunded = null;
        $credit->date_refunded = null;
        $credit->refunded_by = null;
        $credit->is_deleted = 0;
        if ($credit->validate() == true) {
            return $credit;
        } else {
            return new ErrorObject("Error ocurred adding credit");
        }
    }
}
