# Bursary Developer Documentation Module Overview

The Bursary Module  provides payment processing services to the Bursary division.

**Feature Categories**
1. Reports
2. Model Configurations
3. Fee Catalog
4. Account Search
5. Payment Entry
6. Fee Payment Exemptions

## Feature Index
[BUR.5C.1.](#5c1) View Graduation Payments

[BUR.5C.2.](#5c2) Pay Graduation Fee In Full

[BUR.5C.3.](#5c3) Graduation Fee Payment Installment

[BUR.5D.1.](#5d1) Request Graduation Package Modification

[BUR.5D.2.](#5d2) View Graduation Package Modification Requests

[BUR.5D.3.](#5d3) View Graduation Package Modification Request

[BUR.5D.4.](#5d4) Approve Graduation Package Modification Request

[BUR.5D.5.](#5d5) Deny Graduation Package Modification Request

[BUR.5D.6.](#5d6) Process GRaduation Package Modification Request

[BUR.6.1](#6.1) Ad hoc exemption on a single fee

[BUR.6.2](#6.2) Exemption on a cohort level

[BUR.6.3](#6.3) Exemption as a result of transfer reconciliations


## 1. Reports

____

## 2. Fee Catalog

____

## 3. Account Search

____

## 4. Application Account Registration

____

## 5. Payment Entry

### A - Scheduled Payments

### B - Registry and Library Payments

### C - Graduation Payments

### D - Graduation Package Modification

#### 5C.1. View Graduation Payments <span id="5c1"></span>

**User Story**

As a user, I can view student's graduation payments, so that I can;

**Satisfaction Criteria**

1. Determine level of completion
2. Review payment(s) if they exist
3. Access payment options

**System-wide Impacts**

N/A

**User Interface Implications**

- Notification if no payments exist
- List of all payments if any exist
- Conditional list of available actions(Pay In Full, Pay Installment)

**BDD Descriptions**

1. Scenario: Display empty payment report
Given no graduation payments were made by student
When user selects "Pay Graduation Package" button
Then the system generates empty payment listing
And displays available actions of Pay In Full and Pay Installment

2. Scenario: Display incomplete payments
Given graduation payment(s) were made by student
When user selects "Pay Graduation Package" button
Then the system generates listing containing all payments to date
And payment amount remaining
And available action of Pay Installment

2. Scenario: Display completed payments
Given graduation payment(s) amounting to full payment were made by student
When user selects "Pay Graduation Package" button
Then the system generates listing containing all payments to date
And payment amount remaining
And no available actions are present

#### 5C.2. Pay Graduation Fee In Full <span id="5c2"></span>

**User Story**

As a user, I can submit full payment, so that I can;

**Satisfaction Criteria**

1. Record student has fulfilled their financial graduation obligations.

**System-wide Impacts**

N/A

**User Interface Implications**

- User form with package selection options (pre-selected if user had responded to Registry's graduation inquiry).

- Form will include non-editable payment amount field that is set to full payment.

**BDD Descriptions**

1. Scenario: Package pre-selected
Given the student has indicated their payment package
When use selects "Pay In Full" call-to-action button
Then the system generates form with Package field preselected and disabled 
And amount field set to full payment and is disabled

2. Scenario: Package un-selected
Given the student has indicated their payment package
When use selects "Pay In Full" call-to-action button
Then the system generates form with Package field listing available options 
And amount field set to full payment and is disabled

#### 5C.3. Graduation Fee Payment Installment <span id="5c3"></span>

**User Story**

As a user, I can record partial fee payment, so that I can;

**Satisfaction Criteria**

Enable student installment payments for student unable to make full payments.

**System-wide Impacts**

N/A

**User Interface Implications**

- User form with package selection options (pre-selected if user had responded to Registry's graduation inquiry).

- Form will include editable field for payment amount, default set to amount remaining.

**BDD Descriptions**

1. Scenario: First installment package pre-selected
Given the student has indicated their payment package
When use selects "Pay Installment" call-to-action button
Then the system generates form with Package field preselected and disabled 
And amount field set to full payment and is editable

2. Scenario: First installment package un-selected
Given the student has indicated their payment package
When use selects "Pay Installment" call-to-action button
Then the system generates form with Package field listing available options 
And amount field set to full payment and is editable

3. Scenario: First installment package un-selected
Given the student has indicated their payment package
When use selects "Pay Installment" call-to-action button
Then the system generates form with Package field listing available options 
And amount field set to remaining balance and is editable


#### BUR.5D.1. Request Graduation Package Modification <span id="5d1"></span>

**User Story**

As a user, I can submit request to modify graduation package, so that I can;

**Satisfaction Criteria**

1. Express student's intent to change package to Registry
2. Provide Registry officer opportunity to review request

**System-wide Impacts**

1. Request added to listing visible by Registry division,

**User Interface Implications**

- Call to action button in graduation payments view.
- Button changes label to 'Under Review' or "Process Modification" accordingly.

**BDD Descriptions**

**Feature**: Request Graduation Package Modification

This feature facilitates the submission of package update and downgrade request.

**Scenario**: Submit upgrade request
**Given** student has made partial or full payment to a package
**When** I select "Request Package Modification" button
**And** I select more expensive package
**Then** the system generates graduation package upgrade request

**Scenario**: Submit downgrade request
**Given** student has made partial or full payment to a package
**When** I select "Request Package Modification" button
**And** I selects less expensive package
**Then** the system generates graduation package downgrade request


____

## 6. Fee Payment Exemptions

**Background**

Fee payment exemptions are a mechanism used to indicate that a particular fee is not to be taken into consideration when assessing a student's financial standing. This is most commonly needed in cases of programme transfers where there are more than likely differences in the scheduled fee a student is eligible to pay. Instead of voiding an old payment and recording the income generated from those into the current programme's fee, the old receipt will stand and some or all of new fees with be exempted. In cases where the new fee is lower than the previous programme fees the difference will be applied as a credit to students account. This credit can be refunded or used as the basis for a partial fee exemption in the future.

Exemptions are applied in three(3) different contexts;
1. Ad hoc exemption on a single fee.
2. Exemption on a cohort level.
3. Exemption as a result of transfer reconciliations.

### 6.1. User Story - Ad hoc exemption on a single fee <span id="6.1"></span>
As a bursary officer, I can issue an exemption to fee,so that I can amend a student's financial record to disregard fees that are no longer applicable or applied in error.

**Satisfaction Criteria**

1. If fee is unpaid by student then exemption of full fee is applied.
2. If fee is unpaid by student then no credit is applied.
3. If any part of payment was made towards fee then exemption of full fee is applied
4. If any part of payment was made towards fee then a credit, of the amount paid, is added to student account.

**System-wide Impacts**

1. When the scheduled fees are calculated, all exemptions must be taken into account and the amounts due must be adjusted accordingly.

**User Interface Implications**

1. Call-to-action must be available for each billing charge in scheduled fee listing.
2. Exemption listing must be added to student bursary profile.
3. Credit listing must be added to student bursary profile.
4. Total credit on account must be added to profile summary.

**BDD Descriptions**

1. Scenario: Add exemption to unpaid fee
Given no payment has been made on a particular fee
When user indicates an exemption is to be applied
Then the system generates an exemption with an amount of the full fee cost

2. Scenario: Add exemption to partially paid
Given partial payment has been made on a particular fee
When user indicates an exemption is to be applied
Then the system generates an exemption with an amount of the full fee cost
AND the system generates a credit for the amount of the partial payment

### 6.2. User Story - Exemption on a cohort level <span id="6.2"></span>

As a bursary officer, I can issue an exemption to fee(s) on a cohort level,so that I can amend a student's financial record to disregard fees that are no longer applicable or applied in error.

**Satisfaction Criteria**

1. Call-to-action must be available for each billing charge in scheduled fee listing.
2. Exemption listing must be added to student bursary profile.
3. Credit listing must be added to student bursary profile.
4. Total credit on account must be added to profile summary.

**System-wide Impacts**

1. When the scheduled fees are calculated, all exemptions must be taken into account and the amounts due must be adjusted accordingly.

**User Interface Implications**

1. Listing summarising all applied cohort level exemptions.
2. Call-to-action for processing new exemption.
3. Form to permit exemptions application of multiple exemptions for a particular cohort.

**BDD Descriptions**

1. Scenario: Display scheduled fees applicable to cohort
Given that fees are associated with cohort
When use selects that cohort
Then the system generates a form listing all applicable fees with the option to exclusion for each record defaulted to false

2. Scenario: Submission of blank cohort level fee exclusions
Given that fees are associated with cohort
When user submits form with no fee selected for exclusion
Then the system inform user that no fees were selected.

3. Scenario: Submission of valid cohort level fee exclusions
Given that fees are associated with cohort
When user submits form with at least one fee selected
Then the system generates the necessary exemption and credit for each student in the cohort.

### 6.3. User Story - Exemption as a result of transfer reconciliations <span id="6.3"></span>

As a bursary officer, I can issue an exemption to fee(s) on a transfer student account,so that I can amend a student's financial record to disregard fees equal in amounts to fees that were paid under previous registration.

**Satisfaction Criteria**
1. Call-to-action must be available for each billing charge in scheduled fee listing.
2. Exemption listing must be added to student bursary profile.
3. Credit listing must be added to student bursary profile.
4. Total credit on account must be added to profile summary.

**System-wide Impacts**

1. When the scheduled fees are calculated, all exemptions must be taken into account and the amounts due must be adjusted accordingly.

**User Interface Implications**

1. View listing of transfer students by application period which indicates fees reconciliation
status.
2. Form to permit batch exemption of fees.

**BDD Descriptions**

1. Scenario: No transfers exist for an application period
Given no transfers were applied to an application period
When user requests application period listing
Then system excludes that application period from the available selection

2. Scenario: Transfers exist
Given at least one transfer was applied to an application period
When user requests application period listing
Then system includes that application period from the available selection

3. Scenario: View student reconciliation status of unprocessed transfer
Given a student account has a transfer
And no fee reconciliation was done
When user views the summary of that student account
Then system indicates that the reconciliation process is pending

4. Scenario: View student reconciliation status of processed transfer
Given a student account has a transfer
And at least one fee reconciliation was done
When user views the summary of that student account
Then system indicates that the reconciliation process was done 

5. Scenario: View student reconciliation report for unprocessed student
Given a student account has a transfer
When user views the reconciliation report for student account
Then system generates a listing of all applicable fees and current payment status

6. Scenario: View reconciliation report for processed student
Given a student account has a transfer
When user views the reconciliation report for student account
Then system generates a listing of all applicable fees and current payment status
And the system disables all records that have been resolved.

7. Scenario: Submit reconciliation report for processed student
Given a student account has a transfer
When user submits the reconciliation report for student account
Then system generates the necessary exemptions and credit record.
