<?php

namespace app\subcomponents\bursary\controllers;

use Yii;
use yii\base\Model;
use common\models\AdhocBillingChargeFactory;
use common\models\AdhocStudentFeesGenerator;
use common\models\ApplicationPeriodModel;
use common\models\BillingType;
use common\models\BillingTypeModel;
use common\models\ErrorObject;


class StudentServiceFeesController extends \yii\web\Controller
{
    public function actionCatalog($applicationPeriodId, $type)
    {
        $user = Yii::$app->user->identity;

        $period =
            ApplicationPeriodModel::getApplicationPeriodByID(
                $applicationPeriodId
            );

        $title = null;
        if ($type === "graduation") {
            $title = "{$period->name} Graduation Services Catalog";
        } elseif ($type === "registry") {
            $title = "{$period->name} Registry Services Catalog";
        } elseif ($type === "library") {
            $title = "{$period->name} Library Services Catalog";
        }

        $adhocBillingCharges = array();
        $billingTypes = BillingTypeModel::getAdhocBillingTypes($period, $type);

        if (!empty($billingTypes)) {
            foreach ($billingTypes as $billingType) {
                $adhocBillingCharges[] =
                    AdhocBillingChargeFactory::create($billingType, $period);
            }
        }

        if ($postData = Yii::$app->request->post()) {
            if (Model::loadMultiple($adhocBillingCharges, $postData) == true) {
                $generator =
                    new AdhocStudentFeesGenerator(
                        $adhocBillingCharges,
                        $user,
                        $period
                    );

                $feedback = $generator->generateCharges();

                if ($feedback instanceof ErrorObject) {
                    Yii::$app->getSession()->setFlash(
                        "danger",
                        "{$feedback->getMessage()}"
                    );
                } else {
                    Yii::$app->getSession()->setFlash(
                        "success",
                        'Fees added successfully.'
                    );
                    return $this->redirect(["student-fees/view-fee-listing"]);
                }
            }
        }

        return $this->render(
            "catalog",
            [
                "title" => $title,
                "adhocBillingCharges" => $adhocBillingCharges
            ]
        );
    }
}
