<?php

namespace app\subcomponents\bursary\controllers;

use Yii;
use common\models\AcademicOffering;
use common\models\AcademicOfferingModel;
use common\models\ApplicantModel;
use common\models\Application;
use common\models\ApplicationPeriodModel;
use common\models\BillingsByDateSearchForm;
use common\models\BillingModel;
use common\models\EmailModel;
use common\models\ReceiptModel;
use common\models\ReceiptsByDateSearchForm;
use common\models\StudentRegistrationModel;
use common\models\UserModel;
use yii\data\ArrayDataProvider;

class ReportsController extends \yii\web\Controller
{
    public function actionIndex()
    {
        return $this->render("index");
    }


    public function actionBillingsByDate()
    {
        $model = new BillingsByDateSearchForm();

        if ($postData = Yii::$app->request->post()) {
            if ($model->load($postData) == true) {
                return $this->redirect([
                    "billings-by-date-result",
                    "startDate" => $model->startDate,
                    "endDate" => $model->endDate
                ]);
            }
        }
        return $this->render("billings-by-date", ["model" => $model]);
    }


    public function actionBillingsByDateResult($startDate, $endDate)
    {
        $model = new BillingsByDateSearchForm();
        $model->startDate = $startDate;
        $model->endDate = $endDate;
        $billings = BillingModel::getBillingsByDate($model);
        $total = BillingModel::getTotal($billings);

        $dataProvider =
            new ArrayDataProvider(
                [
                    "allModels" =>
                    BillingModel::prepareFormattedBillingListing(
                        $billings
                    ),
                    "pagination" => ["pageSize" => 100],
                    "sort" => [
                        "defaultOrder" => ["receiptId" => SORT_ASC],
                        "attributes" => [
                            "receiptId",
                            "paymentMethod",
                            "billingType",
                            "customerLastname"
                        ]
                    ]
                ]
            );

        return $this->render(
            "billings-by-date-search-results",
            ["dataProvider" => $dataProvider, "total" => $total]
        );
    }


    public function actionReceiptsByDate()
    {
        $model = new ReceiptsByDateSearchForm();

        if ($postData = Yii::$app->request->post()) {
            if ($model->load($postData) == true) {
                return $this->redirect([
                    "receipts-by-date-result",
                    "startDate" => $model->startDate,
                    "endDate" => $model->endDate
                ]);
            }
        }
        return $this->render("receipts-by-date", ["model" => $model]);
    }


    public function actionReceiptsByDateResult($startDate, $endDate)
    {
        $model = new ReceiptsByDateSearchForm();
        $model->startDate = $startDate;
        $model->endDate = $endDate;
        $receipts = ReceiptModel::getReceiptsByDate($model);
        $total = ReceiptModel::getTotal($receipts);

        $dataProvider =
            new ArrayDataProvider(
                [
                    "allModels" =>
                    ReceiptModel::prepareFormattedReceiptReport(
                        $receipts
                    ),
                    "pagination" => ["pageSize" => 200],
                    "sort" => [
                        "defaultOrder" => ["receiptId" => SORT_ASC],
                        "attributes" => [
                            "receiptId",
                            "paymentMethod",
                            "customerLastname"
                        ]
                    ]
                ]
            );

        return $this->render(
            "receipts-by-date-search-results",
            ["dataProvider" => $dataProvider, "total" => $total]
        );
    }


    public function actionGoToProfile($username)
    {
        $customer =
            UserModel::findUserByApplicantIdPotentialStudentIdOrStudentId(
                $username
            );

        $customerClassification =
            UserModel::getUserClassification($customer);

        if ($customerClassification == "Student") {
            return $this->redirect(
                ["profiles/student-profile", "username" => $customer->username]
            );
        } elseif ($customerClassification == "Successful Applicant") {
            return $this->redirect(
                [
                    "profiles/successful-applicant-profile",
                    "username" => $customer->username
                ]
            );
        } elseif ($customerClassification == "Completed Applicant") {
            return $this->redirect(
                [
                    "profiles/completed-applicant-profile",
                    "username" => $customer->username
                ]
            );
        } elseif ($customerClassification == "Abandoned Applicant") {
            return $this->redirect(
                [
                    "profiles/abandoned-applicant-profile",
                    "username" => $customer->username
                ]
            );
        } elseif ($customerClassification == "Incomplete Applicant") {
            return $this->redirect(
                [
                    "profiles/incomplete-applicant-profile",
                    "username" => $customer->username
                ]
            );
        }
    }


    public function actionEnrolmentPaymentsByProgramme(
        $applicationPeriodId = null,
        $academicOfferingId = null
    ) {
        $dataProvider = null;
        $data = array();
        $academicOfferings = array();
        $applicationPeriodName = null;
        $academicOfferingName = null;

        $applicationPeriods =
            ApplicationPeriodModel::getApplicationPeriodsWithActiveStudentFees();

        if ($applicationPeriodId == true) {
            $applicationPeriodName =
                ApplicationPeriodModel::getApplicationPeriodNameByID(
                    $applicationPeriodId
                );

            $academicOfferings =
                ApplicationPeriodModel::generateProgrammeDropdownList(
                    $applicationPeriodId
                );
        }

        if ($academicOfferingId == true) {
            $applications = null;

            if ($academicOfferingId == -1) {
                $applications =
                    Application::find()
                    ->innerJoin(
                        'offer',
                        '`application`.`applicationid` = `offer`.`applicationid`'
                    )
                    ->innerJoin(
                        'academic_offering',
                        '`application`.`academicofferingid` = `academic_offering`.`academicofferingid`'
                    )
                    ->where([
                        "academic_offering.applicationperiodid" => $applicationPeriodId,
                        "application.applicationstatusid" => 9,
                        "application.isactive" => 1,
                        "application.isdeleted" => 0,
                        "offer.ispublished" => 1,
                        "offer.isactive" => 1,
                        "offer.isdeleted" => 0,

                    ])
                    ->all();
            } else {
                $academicOffering =
                    AcademicOfferingModel::getAcademicOfferingByID(
                        $academicOfferingId
                    );
                $academicOfferingName =
                    AcademicOfferingModel::getProgrammeName($academicOffering);

                $applications =
                    AcademicOfferingModel::getSuccessfulApplications(
                        $academicOffering
                    );
            }

            if (!empty($applications)) {
                foreach ($applications as $application) {
                    $app = array();
                    $userAccount = $application->getPerson()->one();

                    $applicantAccount =
                        ApplicantModel::getApplicantByPersonid($application->personid);

                    $app['username'] = $userAccount->username;
                    $app['firstname'] = $applicantAccount->firstname;
                    $app['lastname'] = $applicantAccount->lastname;

                    $academicOffering =
                        AcademicOffering::find()
                        ->where(["academicofferingid" => $application->academicofferingid])
                        ->one();
                    $app['programme'] =
                        AcademicOfferingModel::getProgrammeName($academicOffering);

                    $email = emailModel::getEmailByPersonid($application->personid);
                    $app["email"] = $email->email;


                    $isRegistered =
                        StudentRegistrationModel::applicationRegistrationComplete(
                            $application
                        );
                    if ($isRegistered == true) {
                        $app["registrationStatus"] = "Registered";
                    } else {
                        $app["registrationStatus"] = "Unregistered";
                    }

                    $billingChargesTotal = null;
                    $billingChargesPaid = null;
                    $balance = null;
                    if ($isRegistered == true) {
                        $registration =
                            StudentRegistrationModel::getApplicationRegistration(
                                $application
                            );

                        $paymentsSummary =
                            ApplicantModel::calculateStudentEnrollmentFeesSummary(
                                $application,
                                $registration->currentlevel
                            );
                        $billingChargesTotal = $paymentsSummary["totalCost"];
                        $app['enrolmentBillingChargesTotal'] =
                            $billingChargesTotal;

                        $billingChargesPaid = $paymentsSummary["totalPaid"];
                        $app['enrolmentBillingChargesPaid'] =
                            $billingChargesPaid;

                        $balance = $paymentsSummary["totalDue"];
                        $app["outstandingEnrolmentBalance"] = $balance;
                    } else {
                        $billingChargesTotal =
                            ApplicantModel::getEnrolmentBillingChargesTotal(
                                $application
                            );
                        $app['enrolmentBillingChargesTotal'] =
                            $billingChargesTotal;

                        $billingChargesPaid =
                            ApplicantModel::enrolmentBillingChargesPaid(
                                $application
                            );
                        $app['enrolmentBillingChargesPaid'] =
                            $billingChargesPaid;

                        $balance = $billingChargesTotal - $billingChargesPaid;
                        $app["outstandingEnrolmentBalance"] = $balance;
                    }


                    if ($isRegistered == true) {
                        $registration =
                            StudentRegistrationModel::getApplicationRegistration(
                                $application
                            );
                        if ($registration->currentlevel == 1) {
                            $app["level"] = "Year 1";
                        } elseif ($registration->currentlevel == 2) {
                            $app["level"] = "Year 2";
                        } else {
                            $app["level"] = "Refer to registry";
                        }
                    } else {
                        $app["level"] = "";
                    }

                    if ($isRegistered == true) {
                        $registration =
                            StudentRegistrationModel::getApplicationRegistration(
                                $application
                            );
                        $app["outstandingBillingCharges"]  =
                            ApplicantModel::getAllOutstandingBillingCharges(
                                $application,
                                $registration
                            );
                    } else {
                        $app["outstandingBillingCharges"] =
                            ApplicantModel::getOutstandingBillingCharges($application);
                    }

                    $data[] = $app;
                }
            }

            $dataProvider = new ArrayDataProvider([
                'allModels' => $data,
                'pagination' => [
                    'pageSize' => 100,
                ],
                'sort' => [
                    'attributes' => [
                        'username',
                        'firstname',
                        'lastname'
                    ],
                ],
            ]);
        }

        if ($applicationPeriodId != null && $academicOfferingId != null) {
            return $this->render(
                "enrolment-payments-by-programme-report",
                ["dataProvider" => $dataProvider]
            );
        }

        return $this->render(
            "enrolment-payments-by-programme",
            [
                "applicationPeriods" => $applicationPeriods,
                "applicationPeriodId" => $applicationPeriodId,
                "applicationPeriodName" => $applicationPeriodName,
                "academicOfferingId" => $academicOfferingId,
                "academicOfferingName" => $academicOfferingName,
                "academicOfferings" => $academicOfferings
            ]
        );
    }
}
