<?php

namespace app\subcomponents\bursary\controllers;

use Yii;
use common\models\ErrorObject;
use app\subcomponents\bursary\models\ViewGraduationPaymentsViewModel;
use app\subcomponents\bursary\models\GraduationPackagePaymentEntry;
use app\subcomponents\bursary\models\PackageModificationRequestEntryViewModel;
use app\subcomponents\bursary\models\PreviewGraduationReceiptViewModel;
use app\subcomponents\bursary\models\ProcessPackageModificationRequestViewModel;
use app\subcomponents\bursary\models\RegisterAndPayPackageViewModel;
use app\subcomponents\bursary\models\GraduationOperationValidator;
use common\models\GraduationSurvey;
use common\models\Billing;
use common\models\BillingCharge;
use common\models\BillingChargeModel;
use common\models\GraduationPackageChangeRequest;
use common\models\Receipt;
use common\models\ReceiptModel;
use common\models\StudentRegistration;
use common\models\Student;
use common\models\UserModel;

class GraduationPaymentsController extends \yii\web\Controller
{
    public function actionViewGraduationPayments(
        $username,
        $studentRegistrationId,
        $studentFullName
    ) {
        $viewGraduationPaymentsViewModel =
            ViewGraduationPaymentsViewModel::create(
                $username,
                $studentRegistrationId,
                $studentFullName
            );

        return $this->render(
            "view-graduation-payments",
            ["viewModel" => $viewGraduationPaymentsViewModel]
        );
    }


    // public function actionGraduationPackagePaymentEntry(
    //     $studentRegistrationId,
    //     $paymentStatus,
    //     $billingChargeId = null
    // ) {
    //     $viewModel = null;

    //     if ($billingChargeId == null) {
    //         $viewModel =
    //             GraduationPackagePaymentEntry::createWithoutPreselectedPackage(
    //                 $studentRegistrationId,
    //                 $paymentStatus
    //             );
    //     } else {
    //         $viewModel =
    //             GraduationPackagePaymentEntry::createWithPreselectedPackage(
    //                 $studentRegistrationId,
    //                 $paymentStatus,
    //                 $billingChargeId
    //             );
    //     }

    //     if ($postData = Yii::$app->request->post()) {
    //         if ($viewModel->feePaymentForm->load($postData) == true) {
    //             $user = Yii::$app->user->identity;
    //             $receipt =
    //                 $viewModel->feePaymentForm->processPaymentRequest(
    //                     $user->personid,
    //                     $studentRegistrationId
    //                 );

    //             if ($receipt instanceof ErrorObject) {
    //                 Yii::$app->getSession()->setFlash(
    //                     "warning",
    //                     $receipt->getMessage()
    //                 );
    //             } else {
    //                 return $this->redirect([
    //                     "preview-receipt",
    //                     "receiptId" => $receipt->id,
    //                     "studentRegistrationId" => $studentRegistrationId
    //                 ]);
    //             }
    //         } else {
    //             Yii::$app->getSession()->setFlash(
    //                 "warning",
    //                 "Error occurred load payment"
    //             );
    //         }
    //     }

    //     return $this->render(
    //         "graduation-package-payment-entry",
    //         ["viewModel" => $viewModel]
    //     );
    // }


    public function actionGraduationPackagePaymentEntry(
        $studentRegistrationId,
        $paymentStatus,
        $billingChargeId
    ) {
        $viewModel =
            GraduationPackagePaymentEntry::create(
                $studentRegistrationId,
                $paymentStatus,
                $billingChargeId
            );

        if ($postData = Yii::$app->request->post()) {
            if ($viewModel->feePaymentForm->load($postData) == true) {
                $user = Yii::$app->user->identity;
                $receipt =
                    $viewModel->feePaymentForm->processPaymentRequest(
                        $user->personid,
                        $studentRegistrationId
                    );

                if ($receipt instanceof ErrorObject) {
                    Yii::$app->getSession()->setFlash(
                        "warning",
                        $receipt->getMessage()
                    );
                } else {
                    return $this->redirect([
                        "preview-receipt",
                        "receiptId" => $receipt->id,
                        "studentRegistrationId" => $studentRegistrationId
                    ]);
                }
            } else {
                Yii::$app->getSession()->setFlash(
                    "warning",
                    "Error occurred load payment"
                );
            }
        }

        return $this->render(
            "graduation-package-payment-entry",
            ["viewModel" => $viewModel]
        );
    }


    public function actionPreviewReceipt($receiptId, $studentRegistrationId)
    {
        $viewModel =
            PreviewGraduationReceiptViewModel::create(
                $receiptId,
                $studentRegistrationId
            );

        return $this->render(
            "preview-graduation-receipt",
            ["viewModel" => $viewModel]
        );
    }

    public function actionApproveAndPublishReceipt(
        $receiptId,
        $studentRegistrationId
    ) {
        $paymentPreviewModel =
            PreviewGraduationReceiptViewModel::create(
                $receiptId,
                $studentRegistrationId
            );

        $approvalResult = $paymentPreviewModel->approvePayment($receiptId);

        if ($approvalResult == true) {
            try {
                ReceiptModel::publishReceipt(
                    $this,
                    $paymentPreviewModel->receipt,
                    $paymentPreviewModel->billings,
                    $paymentPreviewModel->fullName,
                    $paymentPreviewModel->username
                );
                Yii::$app->getSession()->setFlash(
                    "success",
                    "Receipt published successfully."
                );
            } catch (\Exception $exception) {
                Yii::$app->getSession()->setFlash(
                    "error",
                    "Receipt publish failed."
                );

                return $this->redirect([
                    "payments/view-receipt",
                    "id" => $receiptId,
                    "username" => $paymentPreviewModel->username
                ]);
            }
        } else {
            Yii::$app->getSession()->setFlash(
                "warning",
                $approvalResult->getMessage()
            );
        }

        return $this->redirect([
            "payments/view-receipt",
            "id" => $receiptId,
            "username" => $paymentPreviewModel->username
        ]);
    }


    public function actionRedoReceipt($receiptId, $studentRegistrationId)
    {

        $receipt = Receipt::find()->where(["id" => $receiptId])->one();;
        $student = UserModel::getUserById($receipt->customer_id);
        $fullName = UserModel::getUserFullname($student);

        $unapprovedGraduationSurvey = GraduationSurvey::find()
            ->where([
                "student_registration_id" => $receipt->student_registration_id,
                "respondent_id" => $receipt->created_by,
                "is_deleted" => 1
            ])
            ->one();

        if ($unapprovedGraduationSurvey == true) {
            $unapprovedGraduationSurvey->delete();
            return $this->redirect([
                "register-and-pay-package",
                "studentRegistrationId" => $studentRegistrationId,
                "billingChargeId" => $unapprovedGraduationSurvey->billing_charge_id
            ]);
        } else {
            return $this->redirect([
                "view-graduation-payments",
                "username" => $student->username,
                "studentRegistrationId" => $studentRegistrationId,
                "studentFullName" => $fullName
            ]);
        }
    }


    // public function actionPayInFull($studentRegistrationId)
    // {
    //     if (BillingChargeModel::getActiveGraduationFees() == false) {
    //         Yii::$app->getSession()->setFlash(
    //             "error",
    //             "Graduation fees not configured for this academic year"
    //         );

    //         $studentRegistration =
    //             StudentRegistration::find()
    //             ->where(["studentregistrationid" => $studentRegistrationId])
    //             ->one();

    //         $student = UserModel::getUserById($studentRegistration->personid);
    //         $studentFullName = UserModel::getUserFullname($student);

    //         return $this->redirect([
    //             "view-graduation-payments",
    //             "username" => $student->username,
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "studentFullName" => $studentFullName
    //         ]);
    //     }

    //     $preSelectedGraduationPackageId =
    //         BillingChargeModel::getGraduationPackageIdSelectedInSurvey(
    //             $studentRegistrationId
    //         );

    //     if ($preSelectedGraduationPackageId == true) {
    //         return $this->redirect([
    //             "graduation-package-payment-entry",
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "paymentStatus" => "full",
    //             "billingChargeId" => $preSelectedGraduationPackageId,
    //         ]);
    //     } else {
    //         return $this->redirect([
    //             "graduation-package-payment-entry",
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "paymentStatus" => "full"
    //         ]);
    //     }
    // }


    // public function actionPayInstallment($studentRegistrationId)
    // {
    //     if (BillingChargeModel::getActiveGraduationFees() == false) {
    //         Yii::$app->getSession()->setFlash(
    //             "error",
    //             "Graduation fees not configured for this academic year"
    //         );

    //         $studentRegistration =
    //             StudentRegistration::find()
    //             ->where(["studentregistrationid" => $studentRegistrationId])
    //             ->one();

    //         $student = UserModel::getUserById($studentRegistration->personid);
    //         $studentFullName = UserModel::getUserFullname($student);

    //         return $this->redirect([
    //             "view-graduation-payments",
    //             "username" => $student->username,
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "studentFullName" => $studentFullName
    //         ]);
    //     }

    //     $preSelectedGraduationPackageId =
    //         BillingChargeModel::getGraduationPackageIdFromInstallmentOrSurvey(
    //             $studentRegistrationId
    //         );

    //     if ($preSelectedGraduationPackageId == true) {
    //         return $this->redirect([
    //             "graduation-package-payment-entry",
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "paymentStatus" => "installment",
    //             "billingChargeId" => $preSelectedGraduationPackageId,
    //         ]);
    //     } else {
    //         return $this->redirect([
    //             "graduation-package-payment-entry",
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "paymentStatus" => "installment"
    //         ]);
    //     }
    // }

    public function actionRegisterAndPayPackage($studentRegistrationId, $billingChargeId = null)
    {
        $graduationSurvey =
            GraduationSurvey::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "is_deleted" => 0
            ])
            ->one();

        $activeChangeRequest =
            GraduationPackageChangeRequest::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "graduation_package_change_request_status_id" => [1, 2],
                "is_deleted" => 0
            ])
            ->one();

        $graduationBillings =
            Billing::find()
            ->innerJoin(
                'billing_charge',
                '`billing`.`billing_charge_id` = `billing_charge`.`id`'
            )
            ->innerJoin(
                'billing_type',
                '`billing_charge`.`billing_type_id` = `billing_type`.`id`'
            )->innerJoin(
                'billing_category',
                '`billing_type`.`billing_category_id` = `billing_category`.`id`'
            )
            ->where([
                "billing.student_registration_id" => $studentRegistrationId,
                "billing.is_active" => 1,
                "billing.is_deleted" => 0,
                "billing_category.name" => "Graduation Services"
            ])
            ->all();

        if (GraduationOperationValidator::canRegisterAndPayPackage(
            $graduationSurvey,
            $activeChangeRequest,
            $graduationBillings
        ) == false) {
            return $this->redirect(Yii::$app->request->getReferrer());
        }

        $viewModel = RegisterAndPayPackageViewModel::create($studentRegistrationId, $billingChargeId);

        if ($postData = Yii::$app->request->post()) {
            if ($viewModel->feePaymentForm->load($postData) == true) {
                $user = Yii::$app->user->identity;
                $receipt =
                    $viewModel->feePaymentForm->processGraduationSurveyGenerationAndPaymentRequest(
                        $user->personid,
                        $studentRegistrationId
                    );

                if ($receipt instanceof ErrorObject) {
                    Yii::$app->getSession()->setFlash(
                        "warning",
                        $receipt->getMessage()
                    );
                } else {
                    return $this->redirect([
                        "preview-receipt",
                        "receiptId" => $receipt->id,
                        "studentRegistrationId" => $studentRegistrationId
                    ]);
                }
            } else {
                Yii::$app->getSession()->setFlash(
                    "warning",
                    "Error occurred load payment"
                );
            }
        }

        return $this->render(
            "register-and-pay-package",
            ["viewModel" => $viewModel]
        );
    }


    // public function actionPayInFull($studentRegistrationId)
    // {
    //     $studentRegistration =
    //         StudentRegistration::find()
    //         ->where(["studentregistrationid" => $studentRegistrationId])
    //         ->one();
    //     $student = UserModel::getUserById($studentRegistration->personid);
    //     $studentFullName = UserModel::getUserFullname($student);

    //     if (BillingChargeModel::getActiveGraduationFees() == false) {
    //         Yii::$app->getSession()->setFlash(
    //             "error",
    //             "Graduation fees not configured for this academic year"
    //         );

    //         return $this->redirect([
    //             "view-graduation-payments",
    //             "username" => $student->username,
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "studentFullName" => $studentFullName
    //         ]);
    //     }

    //     $pendingChangeRequest =
    //         GraduationPackageChangeRequest::find()
    //         ->where([
    //             "student_registration_id" => $studentRegistrationId,
    //             "graduation_package_change_request_status_id" => 1,
    //             "is_active" => 1,
    //             "is_deleted" => 0
    //         ])
    //         ->one();

    //     if ($pendingChangeRequest == true) {
    //         Yii::$app->getSession()->setFlash(
    //             "error",
    //             "Awaiting package change request decision by Registry."
    //         );

    //         return $this->redirect([
    //             "view-graduation-payments",
    //             "username" => $student->username,
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "studentFullName" => $studentFullName
    //         ]);
    //     }

    //     $activeGraduationPackageId =
    //         BillingChargeModel::getActiveGraduationPackageId(
    //             $studentRegistrationId
    //         );

    //     if ($activeGraduationPackageId == null) {
    //         Yii::$app->getSession()->setFlash(
    //             "error",
    //             "Selected graduation package not found. Please contact Registry"
    //         );

    //         return $this->redirect([
    //             "view-graduation-payments",
    //             "username" => $student->username,
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "studentFullName" => $studentFullName
    //         ]);
    //     }

    //     return $this->redirect([
    //         "graduation-package-payment-entry",
    //         "studentRegistrationId" => $studentRegistrationId,
    //         "paymentStatus" => "full",
    //         "billingChargeId" => $activeGraduationPackageId
    //     ]);
    // }


    // public function actionPayInstallment($studentRegistrationId)
    // {
    //     $studentRegistration =
    //         StudentRegistration::find()
    //         ->where(["studentregistrationid" => $studentRegistrationId])
    //         ->one();
    //     $student = UserModel::getUserById($studentRegistration->personid);
    //     $studentFullName = UserModel::getUserFullname($student);

    //     if (BillingChargeModel::getActiveGraduationFees() == false) {
    //         Yii::$app->getSession()->setFlash(
    //             "error",
    //             "Graduation fees not configured for this academic year"
    //         );

    //         return $this->redirect([
    //             "view-graduation-payments",
    //             "username" => $student->username,
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "studentFullName" => $studentFullName
    //         ]);
    //     }

    //     $pendingChangeRequest =
    //         GraduationPackageChangeRequest::find()
    //         ->where([
    //             "student_registration_id" => $studentRegistrationId,
    //             "graduation_package_change_request_status_id" => 1,
    //             "is_active" => 1,
    //             "is_deleted" => 0
    //         ])
    //         ->one();

    //     if ($pendingChangeRequest == true) {
    //         Yii::$app->getSession()->setFlash(
    //             "error",
    //             "Awaiting package change request decision by Registry."
    //         );

    //         return $this->redirect([
    //             "view-graduation-payments",
    //             "username" => $student->username,
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "studentFullName" => $studentFullName
    //         ]);
    //     }

    //     $activeGraduationPackageId =
    //         BillingChargeModel::getActiveGraduationPackageId(
    //             $studentRegistrationId
    //         );

    //     if ($activeGraduationPackageId == null) {
    //         Yii::$app->getSession()->setFlash(
    //             "error",
    //             "Selected graduation package not found. Please contact Registry"
    //         );

    //         return $this->redirect([
    //             "view-graduation-payments",
    //             "username" => $student->username,
    //             "studentRegistrationId" => $studentRegistrationId,
    //             "studentFullName" => $studentFullName
    //         ]);
    //     }

    //     return $this->redirect([
    //         "graduation-package-payment-entry",
    //         "studentRegistrationId" => $studentRegistrationId,
    //         "paymentStatus" => "installment",
    //         "billingChargeId" => $activeGraduationPackageId
    //     ]);
    // }

    public function actionMakePayment($studentRegistrationId)
    {
        $graduationSurvey =
            GraduationSurvey::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "is_deleted" => 0
            ])
            ->one();

        $activeChangeRequest =
            GraduationPackageChangeRequest::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "graduation_package_change_request_status_id" => [1, 2],
                "is_deleted" => 0
            ])
            ->one();

        $graduationBillings =
            Billing::find()
            ->innerJoin(
                'billing_charge',
                '`billing`.`billing_charge_id` = `billing_charge`.`id`'
            )
            ->innerJoin(
                'billing_type',
                '`billing_charge`.`billing_type_id` = `billing_type`.`id`'
            )->innerJoin(
                'billing_category',
                '`billing_type`.`billing_category_id` = `billing_category`.`id`'
            )
            ->where([
                "billing.student_registration_id" => $studentRegistrationId,
                "billing.is_active" => 1,
                "billing.is_deleted" => 0,
                "billing_category.name" => "Graduation Services"
            ])
            ->all();

        if (
            GraduationOperationValidator::canMakePayment(
                $graduationSurvey,
                $activeChangeRequest,
                $graduationBillings
            ) == false
        ) {
            Yii::$app->getSession()->setFlash("error", "Unable to make payment");
            return $this->redirect(Yii::$app->request->getReferrer());
        }

        $activeGraduationPackageId =
            BillingChargeModel::getActiveGraduationPackageId(
                $studentRegistrationId
            );

        if ($activeGraduationPackageId == null) {
            Yii::$app->getSession()->setFlash(
                "error",
                "Selected graduation package not found. Please contact Registry"
            );
            return $this->redirect(Yii::$app->request->getReferrer());
        }

        return $this->redirect([
            "graduation-package-payment-entry",
            "studentRegistrationId" => $studentRegistrationId,
            "paymentStatus" => "installment",
            "billingChargeId" => $activeGraduationPackageId
        ]);
    }

    // To be removed as post payment change request directly calls relevant action
    // Modification of the pre-payment modification request is pending
    public function actionChangePackage(
        //     $studentRegistrationId,
        //     $requestId = null
        // ) {
        $studentRegistrationId
    ) {
        $changeRequests = GraduationPackageChangeRequest::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "is_active" => 1,
                "is_deleted" => 0
            ])
            ->orderBy("id DESC")
            ->all();

        $activeGraduationPackageChangeRequest = null;
        if (!empty($changeRequests)) {
            $activeGraduationPackageChangeRequest = $changeRequests[0];
        }
        // $activeGraduationPackageChangeRequest = 
        //     GraduationPackageChangeRequest::find()
        //     ->where([
        //         "student_registration_id" => $studentRegistrationId,
        //         "is_active" => 1,
        //         "is_deleted" => 0
        //     ])
        //     ->one();

        if ($activeGraduationPackageChangeRequest == false) {
            $graduationReceipts =
                Receipt::find()
                ->innerJoin(
                    'billing',
                    '`billing`.`receipt_id` = `receipt`.`id`'
                )
                ->innerJoin(
                    'billing_charge',
                    '`billing`.`billing_charge_id` = `billing_charge`.`id`'
                )
                ->innerJoin(
                    'billing_type',
                    '`billing_charge`.`billing_type_id` = `billing_type`.`id`'
                )->innerJoin(
                    'billing_category',
                    '`billing_type`.`billing_category_id` = `billing_category`.`id`'
                )
                ->where([
                    "receipt.student_registration_id" => $studentRegistrationId,
                    "receipt.is_active" => 1,
                    "receipt.is_deleted" => 0,
                    "billing_category.name" => "Graduation Services"
                ])
                ->all();

            if ($graduationReceipts == false) {     // generate pre-payment change request
                return $this->redirect([
                    "pre-payment-package-modification-request-entry",
                    "studentRegistrationId" => $studentRegistrationId
                ]);
            } else {                                // generate post-payment change request
                return $this->redirect([
                    "post-payment-package-modification-request-entry",
                    "studentRegistrationId" => $studentRegistrationId
                ]);
            }
        } elseif (
            $activeGraduationPackageChangeRequest == true
            && $activeGraduationPackageChangeRequest->graduation_package_change_request_status_id == 2
        ) {   // Approved
            return $this->redirect([
                "process-package-modification-request",
                "studentRegistrationId" => $studentRegistrationId,
                "requestId" => $activeGraduationPackageChangeRequest->id
            ]);
        } elseif (
            $activeGraduationPackageChangeRequest == true
            && $activeGraduationPackageChangeRequest->graduation_package_change_request_status_id == 3
        ) {   // Rejected
            return $this->redirect([
                "retry-package-modification-request-entry",
                "studentRegistrationId" => $studentRegistrationId
            ]);
        }
    }


    public function actionPostPaymentPackageModificationRequestEntry($studentRegistrationId)
    {
        $studentRegistration =
            StudentRegistration::find()
            ->where(["studentregistrationid" => $studentRegistrationId])
            ->one();

        $student = UserModel::getUserById($studentRegistration->personid);
        $studentFullName = UserModel::getUserFullname($student);

        $viewModel =
            PackageModificationRequestEntryViewModel::createPostPaymentRequest(
                $student->username,
                $studentRegistrationId,
                $studentFullName
            );

        if ($postData = Yii::$app->request->post()) {
            if ($viewModel->form->load($postData) == true) {
                $svgccPersonnel = Yii::$app->user->identity;

                $studentAccount =
                    Student::find()
                    ->where([
                        "personid" => $student->personid,
                        "isactive" => 1,
                        "isdeleted" => 0
                    ])
                    ->one();

                $model = new GraduationPackageChangeRequest();
                $model->person_id = $studentAccount->personid;
                $model->student_registration_id = $studentRegistrationId;
                $model->username = $student->username;
                $model->first_name = $studentAccount->firstname;
                $model->last_name = $studentAccount->lastname;
                $model->date_created = date("Y-m-d H:i:s");
                $model->created_by = $svgccPersonnel->personid;
                $model->date_reviewed = null;
                $model->reviewed_by = null;
                $model->date_paid = null;
                $model->paid_by = null;
                $model->current_package_id = $viewModel->billingChargeId;
                $model->proposed_package_id = $viewModel->form->billingChargeId;

                $currentPackage =
                    BillingCharge::find()
                    ->where([
                        "id" => $viewModel->billingChargeId,
                        "is_active" => 1,
                        "is_deleted" => 0
                    ])
                    ->one();

                $proposedPackage =
                    BillingCharge::find()
                    ->where([
                        "id" => $viewModel->form->billingChargeId,
                        "is_active" => 1,
                        "is_deleted" => 0
                    ])
                    ->one();

                $model->cost_delta =
                    $proposedPackage->cost - $currentPackage->cost;

                $model->graduation_package_change_request_status_id = 1;
                $model->graduation_package_change_request_type_id = 2;
                $model->is_active = 1;
                $model->is_deleted = 0;
                if ($model->save() == true) {
                    return $this->redirect([
                        "view-graduation-payments",
                        "username" => $student->username,
                        "studentRegistrationId" => $studentRegistrationId,
                        "studentFullName" => $studentFullName
                    ]);
                } else {
                    Yii::$app->getSession()->setFlash(
                        "warning",
                        "Error occurred processing package modification request"
                    );
                }
            }
        }

        return $this->render(
            "package-modification-request-entry",
            ["viewModel" => $viewModel]
        );
    }


    public function actionRetryPackageModificationRequestEntry($studentRegistrationId)
    {
        $viewModel = null;

        $studentRegistration =
            StudentRegistration::find()
            ->where(["studentregistrationid" => $studentRegistrationId])
            ->one();

        $student = UserModel::getUserById($studentRegistration->personid);
        $studentFullName = UserModel::getUserFullname($student);

        $graduationReceipts =
            Receipt::find()
            ->innerJoin(
                'billing',
                '`billing`.`receipt_id` = `receipt`.`id`'
            )
            ->innerJoin(
                'billing_charge',
                '`billing`.`billing_charge_id` = `billing_charge`.`id`'
            )
            ->innerJoin(
                'billing_type',
                '`billing_charge`.`billing_type_id` = `billing_type`.`id`'
            )->innerJoin(
                'billing_category',
                '`billing_type`.`billing_category_id` = `billing_category`.`id`'
            )
            ->where([
                "receipt.student_registration_id" => $studentRegistrationId,
                "receipt.is_active" => 1,
                "receipt.is_deleted" => 0,
                "billing_category.name" => "Graduation Services"
            ])
            ->all();

        if ($graduationReceipts == false) {     // generate pre-payment change request
            $viewModel =
                PackageModificationRequestEntryViewModel::createPrePaymentRequest(
                    $student->username,
                    $studentRegistrationId,
                    $studentFullName
                );
        } else {                                // generate post-payment change request
            $viewModel =
                PackageModificationRequestEntryViewModel::createPostPaymentRequest(
                    $student->username,
                    $studentRegistrationId,
                    $studentFullName
                );
        }

        if ($postData = Yii::$app->request->post()) {
            if ($viewModel->form->load($postData) == true) {
                $oldRequest =
                    GraduationPackageChangeRequest::find()
                    ->where([
                        "student_registration_id" => $studentRegistrationId,
                        "is_active" => 1,
                        "is_deleted" => 0
                    ])
                    ->one();
                $oldRequest->is_active = 0;

                $svgccPersonnel = Yii::$app->user->identity;

                $studentAccount =
                    Student::find()
                    ->where([
                        "personid" => $student->personid,
                        "isactive" => 1,
                        "isdeleted" => 0
                    ])
                    ->one();

                $newRequest = new GraduationPackageChangeRequest();
                $newRequest->person_id = $studentAccount->personid;
                $newRequest->student_registration_id = $studentRegistrationId;
                $newRequest->username = $student->username;
                $newRequest->first_name = $studentAccount->firstname;
                $newRequest->last_name = $studentAccount->lastname;
                $newRequest->date_created = date("Y-m-d H:i:s");
                $newRequest->created_by = $svgccPersonnel->personid;
                $newRequest->date_reviewed = null;
                $newRequest->reviewed_by = null;
                $newRequest->date_paid = null;
                $newRequest->paid_by = null;
                $newRequest->current_package_id = $viewModel->billingChargeId;
                $newRequest->proposed_package_id = $viewModel->form->billingChargeId;

                $currentPackage =
                    BillingCharge::find()
                    ->where([
                        "id" => $viewModel->billingChargeId,
                        "is_active" => 1,
                        "is_deleted" => 0
                    ])
                    ->one();

                $proposedPackage =
                    BillingCharge::find()
                    ->where([
                        "id" => $viewModel->form->billingChargeId,
                        "is_active" => 1,
                        "is_deleted" => 0
                    ])
                    ->one();

                $newRequest->cost_delta =
                    $proposedPackage->cost - $currentPackage->cost;

                $newRequest->graduation_package_change_request_type_id =
                    $oldRequest->graduation_package_change_request_type_id;

                $newRequest->graduation_package_change_request_status_id = 1;
                $newRequest->is_active = 1;
                $newRequest->is_deleted = 0;
                if ($oldRequest->save() == true && $newRequest->save() == true) {
                    return $this->redirect([
                        "view-graduation-payments",
                        "username" => $student->username,
                        "studentRegistrationId" => $studentRegistrationId,
                        "studentFullName" => $studentFullName
                    ]);
                } else {
                    Yii::$app->getSession()->setFlash(
                        "warning",
                        "Error occurred processing package modification request"
                    );
                }
            }
        }

        return $this->render(
            "package-modification-request-entry",
            ["viewModel" => $viewModel]
        );
    }


    public function actionPrePaymentPackageModificationRequestEntry(
        $studentRegistrationId
    ) {
        $graduationSurvey =
            GraduationSurvey::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "is_deleted" => 0
            ])
            ->one();

        $activeChangeRequest =
            GraduationPackageChangeRequest::find()
            ->where([
                "student_registration_id" => $studentRegistrationId,
                "graduation_package_change_request_status_id" => [1, 2],
                "is_deleted" => 0
            ])
            ->one();

        $graduationBillings =
            Billing::find()
            ->innerJoin(
                'billing_charge',
                '`billing`.`billing_charge_id` = `billing_charge`.`id`'
            )
            ->innerJoin(
                'billing_type',
                '`billing_charge`.`billing_type_id` = `billing_type`.`id`'
            )->innerJoin(
                'billing_category',
                '`billing_type`.`billing_category_id` = `billing_category`.`id`'
            )
            ->where([
                "billing.student_registration_id" => $studentRegistrationId,
                "billing.is_active" => 1,
                "billing.is_deleted" => 0,
                "billing_category.name" => "Graduation Services"
            ])
            ->all();

        if (
            GraduationOperationValidator::canCreatePrePaymentChangeRequest(
                $graduationSurvey,
                $activeChangeRequest,
                $graduationBillings
            ) == false
        ) {
            Yii::$app->getSession()->setFlash("error", "Unable to change package");
            return $this->redirect(Yii::$app->request->getReferrer());
        }

        $studentRegistration =
            StudentRegistration::find()
            ->where(["studentregistrationid" => $studentRegistrationId])
            ->one();

        $student = UserModel::getUserById($studentRegistration->personid);
        $studentFullName = UserModel::getUserFullname($student);

        $viewModel =
            PackageModificationRequestEntryViewModel::createPrePaymentRequest(
                $student->username,
                $studentRegistrationId,
                $studentFullName
            );

        if ($postData = Yii::$app->request->post()) {
            if ($viewModel->form->load($postData) == true) {
                $svgccPersonnel = Yii::$app->user->identity;

                $studentAccount =
                    Student::find()
                    ->where([
                        "personid" => $student->personid,
                        "isactive" => 1,
                        "isdeleted" => 0
                    ])
                    ->one();

                $model = new GraduationPackageChangeRequest();
                $model->person_id = $studentAccount->personid;
                $model->student_registration_id = $studentRegistrationId;
                $model->username = $student->username;
                $model->first_name = $studentAccount->firstname;
                $model->last_name = $studentAccount->lastname;
                $model->date_created = date("Y-m-d H:i:s");
                $model->created_by = $svgccPersonnel->personid;
                $model->date_reviewed = null;
                $model->reviewed_by = null;
                $model->date_paid = null;
                $model->paid_by = null;
                $model->current_package_id = $viewModel->billingChargeId;
                $model->proposed_package_id = $viewModel->form->billingChargeId;

                $currentPackage =
                    BillingCharge::find()
                    ->where([
                        "id" => $viewModel->billingChargeId,
                        "is_active" => 1,
                        "is_deleted" => 0
                    ])
                    ->one();

                $proposedPackage =
                    BillingCharge::find()
                    ->where([
                        "id" => $viewModel->form->billingChargeId,
                        "is_active" => 1,
                        "is_deleted" => 0
                    ])
                    ->one();

                if ($currentPackage == true) {
                    $model->cost_delta =
                        $proposedPackage->cost - $currentPackage->cost;
                } else {
                    $model->cost_delta = 0;
                }

                $model->graduation_package_change_request_status_id = 1;
                $model->graduation_package_change_request_type_id = 1;
                $model->is_active = 1;
                $model->is_deleted = 0;
                if ($model->save() == true) {
                    return $this->redirect([
                        "view-graduation-payments",
                        "username" => $student->username,
                        "studentRegistrationId" => $studentRegistrationId,
                        "studentFullName" => $studentFullName
                    ]);
                } else {
                    Yii::$app->getSession()->setFlash(
                        "warning",
                        "Error occurred processing package modification request"
                    );
                }
            }
        }

        return $this->render(
            "package-modification-request-entry",
            ["viewModel" => $viewModel]
        );
    }


    public function actionProcessPackageModificationRequest(
        $studentRegistrationId,
        $requestId
    ) {
        $packageModificationRequest =
            GraduationPackageChangeRequest::find()
            ->where(["id" => $requestId])
            ->one();

        $viewModel =
            ProcessPackageModificationRequestViewModel::create(
                $packageModificationRequest
            );

        if ($postData = Yii::$app->request->post()) {
            if ($viewModel->feePaymentForm->load($postData) == true) {
                $svgccPersonnel = Yii::$app->user->identity;

                $receipt =
                    $viewModel
                    ->feePaymentForm
                    ->processGraduationPackageChangeRequest(
                        $svgccPersonnel->personid,
                        $packageModificationRequest
                    );

                if ($receipt instanceof ErrorObject) {
                    Yii::$app->getSession()->setFlash(
                        "warning",
                        $receipt->getMessage()
                    );
                } else {
                    return $this->redirect([
                        "preview-receipt",
                        "receiptId" => $receipt->id,
                        "studentRegistrationId" => $studentRegistrationId
                    ]);
                }
            } else {
                Yii::$app->getSession()->setFlash(
                    "warning",
                    "Error occurred load payment"
                );
            }
        }

        return $this->render(
            "graduation-package-payment-entry",
            ["viewModel" => $viewModel]
        );
    }
}
