<?php

use yii\helpers\Url;
use kartik\grid\GridView;
use kartik\export\ExportMenu;


$this->title = $title;
$this->params["breadcrumbs"][] = ["label" => "Applicant Dashboard", "url" => Url::toRoute(["/subcomponents/admissions/process-applications"])];
$this->params["breadcrumbs"][] = $this->title;
?>


<h2 class="text-center"><?= $this->title ?></h2>

<div class="box box-primary table-responsive no-padding">
    <div class="box-header with-border">
        <span class="box-title">Summary</span>
    </div>

    <div class="box-body">
        <table class="table table-responsive">
            <thead>
                <tr>
                    <td>Submitted</td>
                    <td>Verified</td>
                    <td>Unverified</td>
                    <td>Pending</td>
                    <td>Shortlisted</td>
                    <td>Borderline</td>
                    <td>Pre-Interview Rejections</td>
                    <td>Interviewees</td>
                    <td>Post Interview Rejections</td>
                    <td>Offers</td>
                    <td>Meet Matriculation Requirements</td>
                    <td>Applicants With Four Passes</td>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <td><?= $summaryStatistics["totalSubmitted"] ?></td>
                    <td><?= $summaryStatistics["totalVerified"] ?></td>
                    <td><?= $summaryStatistics["totalUnverified"] ?></td>
                    <td><?= $summaryStatistics["totalPending"] ?></td>
                    <td><?= $summaryStatistics["totalShortlisted"] ?></td>
                    <td><?= $summaryStatistics["totalBorderline"] ?></td>
                    <td><?= $summaryStatistics["totalPreInterviewRejections"] ?></td>
                    <td><?= $summaryStatistics["totalInterviewees"] ?></td>
                    <td><?= $summaryStatistics["totalPostInterviewRejects"] ?></td>
                    <td><?= $summaryStatistics["totalOffers"] ?></td>
                    <td><?= $summaryStatistics["greaterThanOrEqualToFivePassesWithEnglish"] ?></td>
                    <td><?= $summaryStatistics["hasFourPasses"] ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>


<div class="box box-primary table-responsive no-padding">
    <div class="box-header with-border">
        <span class="box-title">Applicant Listing</span>
    </div>

    <div class="box-body">
        <?php if ($dataProvider) : ?>
            <h4>Click the following links to download the listing seen below.</h4>

            <div>
                <?= ExportMenu::widget([
                    "dataProvider" => $dataProvider,
                    "columns" => [
                        [
                            "attribute" => "id",
                            "format" => "text",
                            "label" => "Applicant ID"
                        ],
                        [
                            "attribute" => "firstName",
                            "format" => "text",
                            "label" => "First Name"
                        ],
                        [
                            "attribute" => "lastName",
                            "format" => "text",
                            "label" => "Last Name"
                        ],
                        [
                            "attribute" => "firstChoice",
                            "format" => "text",
                            "label" => "1st Choice"
                        ],
                        [
                            "attribute" => "secondChoice",
                            "format" => "text",
                            "label" => "2nd Choice"
                        ],
                        [
                            "attribute" => "thirdChoice",
                            "format" => "text",
                            "label" => "3rd Choice"
                        ],
                        [
                            "attribute" => "applicationStatus",
                            "format" => "text",
                            "label" => "Status"
                        ],
                        [
                            "attribute" => "totalPasses",
                            "format" => "text",
                            "label" => "CSEC/GCE Passes"
                        ],
                        [
                            "attribute" => "noOfOnes",
                            "format" => "text",
                            "label" => "CSEC/GCE 1s"
                        ],
                        [
                            "attribute" => "noOfTwos",
                            "format" => "text",
                            "label" => "CSEC/GCE 2s"
                        ],
                        [
                            "attribute" => "noOfThrees",
                            "format" => "text",
                            "label" => "CSEC/GCE 3s"
                        ],
                        [
                            "attribute" => "hasFivePassesIncludingEnglish",
                            "format" => "text",
                            "label" => "Meets Matriculation Requirements"
                        ],
                        [
                            "attribute" => "has4Passes",
                            "format" => "text",
                            "label" => "Has 4 Passes"
                        ],
                    ],
                    "fontAwesome" => true,
                    "dropdownOptions" => [
                        "label" => "Select Export Type",
                        "class" => "btn btn-default"
                    ],
                    "asDropdown" => false,
                    "showColumnSelector" => false,
                    "filename" => "Admissions Report",
                    "exportConfig" => [
                        ExportMenu::FORMAT_TEXT => false,
                        ExportMenu::FORMAT_HTML => false,
                        ExportMenu::FORMAT_EXCEL => false,
                        ExportMenu::FORMAT_EXCEL_X => false
                    ],
                ]);
                ?>
            </div><br />


            <?= GridView::widget([
                "dataProvider" => $dataProvider,
                "options" => ["style" => "width: 100%; margin: 0 auto;"],
                "columns" => [
                    [
                        "attribute" => "id",
                        "format" => "text",
                        "label" => "Applicant ID"
                    ],
                    [
                        "attribute" => "firstName",
                        "format" => "text",
                        "label" => "First Name"
                    ],
                    [
                        "attribute" => "lastName",
                        "format" => "text",
                        "label" => "Last Name"
                    ],
                    [
                        "attribute" => "firstChoice",
                        "format" => "text",
                        "label" => "1st Choice"
                    ],
                    [
                        "attribute" => "secondChoice",
                        "format" => "text",
                        "label" => "2nd Choice"
                    ],
                    [
                        "attribute" => "thirdChoice",
                        "format" => "text",
                        "label" => "3rd Choice"
                    ],
                    [
                        "attribute" => "applicationStatus",
                        "format" => "text",
                        "label" => "Status"
                    ],
                    [
                        "attribute" => "totalPasses",
                        "format" => "text",
                        "label" => "CSEC/GCE Passes"
                    ],
                    [
                        "attribute" => "noOfOnes",
                        "format" => "text",
                        "label" => "CSEC/GCE 1s"
                    ],
                    [
                        "attribute" => "noOfTwos",
                        "format" => "text",
                        "label" => "CSEC/GCE 2s"
                    ],
                    [
                        "attribute" => "noOfThrees",
                        "format" => "text",
                        "label" => "CSEC/GCE 3s"
                    ],
                    [
                        "attribute" => "hasFivePassesIncludingEnglish",
                        "format" => "text",
                        "label" => "Meets Matriculation Requirements"
                    ],
                    [
                        "attribute" => "has4Passes",
                        "format" => "text",
                        "label" => "Has 4 Passes"
                    ],
                ],
            ]);
            ?>
        <?php endif; ?>
    </div>
</div>