<?php

use yii\helpers\Url;

$this->title = "Student Profile";

$this->params["breadcrumbs"][] =
    [
        "label" => "Review Applicants",
        "url" => Url::toRoute(["/subcomponents/admissions/process-applications"])
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<div class="box box-primary table-responsive no-padding">
    <div class="box-body">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3>Biographical Information</h3>
            </div>

            <div class="panel-body">
                <table class="table table-hover">
                    <tr>
                        <th>Username</th>
                        <td><?= $model->username ?></td>
                        <th>Full Name</th>
                        <td><?= $model->fullName ?></td>
                    </tr>

                    <tr>
                        <th>Date Of Birth</th>
                        <td><?= $model->dateOfBirth; ?></td>
                        <th>Gender</th>
                        <td><?= $model->gender; ?></td>
                    </tr>

                    <tr>
                        <th>Nationality</th>
                        <td><?= $model->nationality; ?></td>
                        <th>Place Of Birth</th>
                        <td><?= $model->placeOfBirth; ?></td>
                    </tr>

                    <tr>
                        <th>Sponsor's Name</th>
                        <td><?= $model->sponsorName; ?></td>
                        <th>Beneficiary Information</th>
                        <td><?= $model->beneficiaryDetails; ?></td>
                    </tr>
                </table>
            </div>
        </div>

        <?php foreach ($model->studentRegistrations as $registration) : ?>
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3><?= $registration->programme ?></h3>
                </div>

                <div class="panel-body">
                    <table class="table table-hover">
                        <tr>
                            <td rowspan="2">
                                <img src=<?= $model->displayPicture; ?> alt="avatar" class="img-rounded">
                            </td>
                            <th>Level </th>
                            <td><?= $registration->level ?></td>
                            <?php if (isset($registration->cumulativeGpa)) : ?>
                                <th>Cumulative GPA</th>
                                <td><?= $registration->cumulativeGpa ?></td>
                            <?php endif; ?>
                        </tr>
                        <tr>
                            <th>Academic Status</th>
                            <td><?= $registration->academicStatus ?></td>
                            <th>Student Status</th>
                            <td><?= $registration->studentStatus ?></td>
                        </tr>
                    </table><br />

                    <?php if (!empty($registration->semesterTranscripts)) : ?>
                        <?php foreach ($registration->semesterTranscripts as $semester) : ?>
                            <?= $semester->label; ?>

                            <table class="table table-hover">
                                <?= $registration->transcriptFields ?>
                                <?php foreach ($semester->grades as $grade) : ?>
                                    <?= $grade->toHtmlTableRowElement() ?>
                                <?php endforeach; ?>
                            </table><br />
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div><br /><br />
        <?php endforeach; ?>
    </div>
</div>