<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = "Applicant Profile Preview";

$this->params["breadcrumbs"][] =
    [
        "label" => "Review Applicants",
        "url" => Url::toRoute(["/subcomponents/admissions/process-applications"])
    ];

$this->params["breadcrumbs"][] = $this->title;
?>

<h1><?= $this->title ?></h1>

<span class="label label-info pull-right">
    <h5><?= $model->status ?></h5>
</span>

<div class="box box-primary table-responsive no-padding">
    <div class="box-body">
        <div class="panel panel-default">
            <div class="panel-heading"><?= $model->fullName ?></div>

            <div class="panel-body">
                <table class="table table-hover">
                    <tr>
                        <td rowspan="3">
                            <img src=<?= $model->displayPicture; ?> alt="avatar" class="img-rounded">
                        </td>
                        <th>Username</th>
                        <td><?= $model->username; ?></td>
                        <th>Applications</th>
                        <td>
                            <?php foreach ($model->applicationDetails as $detail) : ?>
                                <?= "{$detail['ordering']} - {$detail['name']}"; ?><br />
                            <?php endforeach; ?>
                        </td>
                    </tr>

                    <tr>
                        <th>Date Of Birth</th>
                        <td><?= $model->dateOfBirth; ?></td>
                        <th>Gender</th>
                        <td><?= $model->gender; ?></td>
                    </tr>

                    <tr>
                        <th>Nationality</th>
                        <td><?= $model->nationality; ?></td>
                        <th>Place Of Birth</th>
                        <td><?= $model->placeOfBirth; ?></td>
                    </tr>

                    <tr>
                        <td></td>
                        <th>Sponsor's Name</th>
                        <td><?= $model->sponsorName; ?></td>
                        <th>Beneficiary Information</th>
                        <td><?= $model->beneficiaryDetails; ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>