<?php

namespace app\subcomponents\admissions\models;

class Grade
{

    public $courseCode;
    public $courseName;
    public $creditsAttempted;
    public $creditsAwarded;
    public $courseworkMarks;
    public $examMarks;
    public $finalMarks;
    public $courseStatus;
    public $grade;
    public $qualityPoints;
    public $gradePoints;


    public function __construct(
        $courseCode,
        $courseName,
        $creditsAttempted,
        $creditsAwarded,
        $courseworkMarks,
        $examMarks,
        $finalMarks,
        $courseStatus,
        $grade,
        $qualityPoints,
        $gradePoints
    ) {
        $this->courseCode = $courseCode;
        $this->courseName = $courseName;
        $this->creditsAttempted = $creditsAttempted;
        $this->creditsAwarded = $creditsAwarded;
        $this->courseworkMarks = $courseworkMarks;
        $this->examMarks = $examMarks;
        $this->finalMarks = $finalMarks;
        $this->courseStatus = $courseStatus;
        $this->grade = $grade;
        $this->qualityPoints = $qualityPoints;
        $this->gradePoints = $gradePoints;
    }


    /**
     * Grade Factory method
     *
     * @param array $courseResult
     * @return Grade
     */
    public static function createGradeFromCourseResultArray($courseResult)
    {
        $courseStatus = $courseResult["courseStatus"];

        if ($courseStatus == "P") {
            $creditsAwarded = $courseResult["creditsAttempted"];
        } else {
            $creditsAwarded = 0;
        }
        $gradePoints =  $creditsAwarded * $courseResult["qualityPoints"];

        return new Grade(
            $courseResult["courseCode"],
            $courseResult["courseName"],
            $courseResult["creditsAttempted"],
            $creditsAwarded,
            $courseResult["cw"],
            $courseResult["exam"],
            $courseResult["final"],
            $courseResult["courseStatus"],
            $courseResult["grade"],
            $courseResult["qualityPoints"],
            $gradePoints
        );
    }


    /**
     * Returns model as an HTML table row element
     *
     * @return string
     */
    public function toHtmlTableRowElement()
    {
        return "<tr>"
            . "<td>{$this->courseCode}</td>"
            . "<td>{$this->courseName}</td>"
            . "<td>{$this->creditsAttempted}</td>"
            . "<td>{$this->creditsAwarded}</td>"
            . "<td>{$this->courseworkMarks}</td>"
            . "<td>{$this->examMarks}</td>"
            . "<td>{$this->finalMarks}</td>"
            . "<td>{$this->courseStatus}</td>"
            . "<td>{$this->grade}</td>"
            . "<td>{$this->qualityPoints}</td>"
            . "<td>{$this->gradePoints}</td>"
            . "</tr>";
    }
}
